/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceWriter
extends AbstractWriter<PerformanceVector> {
    public static final String PARAMETER_PERFORMANCE_FILE = "performance_file";

    public PerformanceWriter(OperatorDescription description) {
        super(description, PerformanceVector.class);
    }

    @Override
    public PerformanceVector write(PerformanceVector performance) throws OperatorException {
        File performanceFile = this.getParameterAsFile(PARAMETER_PERFORMANCE_FILE, true);
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(performanceFile);
                performance.write(out);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, performanceFile, e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + performanceFile);
                }
            }
        }
        return performance;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_PERFORMANCE_FILE, "Filename for the performance file.", "per", false));
        return types;
    }
}

