/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.functions.LinearRegressionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearRegression
extends AbstractLearner {
    public static final String PARAMETER_FEATURE_SELECTION = "feature_selection";
    public static final String PARAMETER_ELIMINATE_COLINEAR_FEATURES = "eliminate_colinear_features";
    public static final String PARAMETER_USE_BIAS = "use_bias";
    public static final String PARAMETER_MIN_STANDARDIZED_COEFFICIENT = "min_standardized_coefficient";
    public static final String PARAMETER_RIDGE = "ridge";
    public static final String[] FEATURE_SELECTION_METHODS = new String[]{"none", "M5 prime", "greedy"};
    public static final int NO_SELECTION = 0;
    public static final int M5_PRIME = 1;
    public static final int GREEDY = 2;

    public LinearRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label;
        Attribute workingLabel = label = exampleSet.getAttributes().getLabel();
        boolean cleanUpLabel = false;
        String firstClassName = null;
        String secondClassName = null;
        boolean useBias = this.getParameterAsBoolean(PARAMETER_USE_BIAS);
        if (label.isNominal() && label.getMapping().size() == 2) {
            firstClassName = label.getMapping().getNegativeString();
            secondClassName = label.getMapping().getPositiveString();
            int firstIndex = label.getMapping().getNegativeIndex();
            workingLabel = AttributeFactory.createAttribute("regression_label", 4);
            exampleSet.getExampleTable().addAttribute(workingLabel);
            for (Example example : exampleSet) {
                double index = example.getValue(label);
                if (index == (double)firstIndex) {
                    example.setValue(workingLabel, 0.0);
                    continue;
                }
                example.setValue(workingLabel, 1.0);
            }
            exampleSet.getAttributes().setLabel(workingLabel);
            cleanUpLabel = true;
        }
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean[] attributeSelection = new boolean[numberOfAttributes];
        int counter = 0;
        String[] attributeNames = new String[numberOfAttributes];
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeSelection[counter] = attribute.isNumerical();
            attributeNames[counter] = attribute.getName();
            ++counter;
        }
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[numberOfAttributes];
        double[] standardDeviations = new double[numberOfAttributes];
        counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attributeSelection[counter]) {
                means[counter] = exampleSet.getStatistics(attribute, "average_weighted");
                standardDeviations[counter] = Math.sqrt(exampleSet.getStatistics(attribute, "variance_weighted"));
                if (standardDeviations[counter] == 0.0) {
                    attributeSelection[counter] = false;
                }
            }
            ++counter;
        }
        double labelMean = exampleSet.getStatistics(workingLabel, "average_weighted");
        double classStandardDeviation = Math.sqrt(exampleSet.getStatistics(workingLabel, "variance_weighted"));
        int numberOfExamples = exampleSet.size();
        double[] coefficients = new double[numberOfAttributes + 1];
        do {
            coefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean);
        } while (this.getParameterAsBoolean(PARAMETER_ELIMINATE_COLINEAR_FEATURES) && this.deselectAttributeWithHighestCoefficient(attributeSelection, coefficients, standardDeviations, classStandardDeviation));
        int currentlySelectedAttributes = 1;
        int i = 0;
        while (i < attributeSelection.length) {
            if (attributeSelection[i]) {
                ++currentlySelectedAttributes;
            }
            ++i;
        }
        double error = this.getSquaredError(exampleSet, attributeSelection, coefficients, useBias);
        double akaike = numberOfExamples - currentlySelectedAttributes + 2 * currentlySelectedAttributes;
        int currentNumberOfAttributes = currentlySelectedAttributes;
        switch (this.getParameterAsInt(PARAMETER_FEATURE_SELECTION)) {
            case 2: {
                boolean improved;
                do {
                    boolean[] currentlySelected = (boolean[])attributeSelection.clone();
                    improved = false;
                    --currentNumberOfAttributes;
                    int i2 = 0;
                    while (i2 < attributeSelection.length) {
                        if (currentlySelected[i2]) {
                            currentlySelected[i2] = false;
                            double[] currentCoeffs = this.performRegression(exampleSet, currentlySelected, means, labelMean);
                            double currentMSE = this.getSquaredError(exampleSet, currentlySelected, currentCoeffs, useBias);
                            double currentAkaike = currentMSE / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                            if (currentAkaike < akaike) {
                                improved = true;
                                akaike = currentAkaike;
                                System.arraycopy(currentlySelected, 0, attributeSelection, 0, attributeSelection.length);
                                coefficients = currentCoeffs;
                            }
                            currentlySelected[i2] = true;
                        }
                        ++i2;
                    }
                } while (improved);
                break;
            }
            case 1: {
                boolean improved;
                do {
                    improved = false;
                    --currentNumberOfAttributes;
                    double minStadardizedCoefficient = 0.0;
                    int attribute2Deselect = -1;
                    int coefficientIndex = 0;
                    int i3 = 0;
                    while (i3 < attributeSelection.length) {
                        if (attributeSelection[i3]) {
                            double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i3] / classStandardDeviation);
                            if (coefficientIndex == 0 || standardizedCoefficient < minStadardizedCoefficient) {
                                minStadardizedCoefficient = standardizedCoefficient;
                                attribute2Deselect = i3;
                            }
                            ++coefficientIndex;
                        }
                        ++i3;
                    }
                    if (attribute2Deselect < 0) continue;
                    attributeSelection[attribute2Deselect] = false;
                    double[] currentCoefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean);
                    double currentError = this.getSquaredError(exampleSet, attributeSelection, currentCoefficients, useBias);
                    double currentAkaike = currentError / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                    if (currentAkaike < akaike) {
                        improved = true;
                        akaike = currentAkaike;
                        coefficients = currentCoefficients;
                        continue;
                    }
                    attributeSelection[attribute2Deselect] = true;
                } while (improved);
                break;
            }
        }
        if (cleanUpLabel) {
            exampleSet.getAttributes().remove(workingLabel);
            exampleSet.getExampleTable().removeAttribute(workingLabel);
            exampleSet.getAttributes().setLabel(label);
        }
        return new LinearRegressionModel(exampleSet, attributeSelection, coefficients, useBias, firstClassName, secondClassName);
    }

    private boolean deselectAttributeWithHighestCoefficient(boolean[] selectedAttributes, double[] coefficients, double[] standardDeviations, double classStandardDeviation) throws UndefinedParameterError {
        double minCoefficient = this.getParameterAsDouble(PARAMETER_MIN_STANDARDIZED_COEFFICIENT);
        int attribute2Deselect = -1;
        int coefficientIndex = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i] / classStandardDeviation);
                if (standardizedCoefficient > minCoefficient) {
                    minCoefficient = standardizedCoefficient;
                    attribute2Deselect = i;
                }
                ++coefficientIndex;
            }
            ++i;
        }
        if (attribute2Deselect >= 0) {
            selectedAttributes[attribute2Deselect] = false;
            return true;
        }
        return false;
    }

    private double getSquaredError(ExampleSet exampleSet, boolean[] selectedAttributes, double[] coefficients, boolean useIntercept) {
        double error = 0.0;
        for (Example example : exampleSet) {
            double prediction = this.regressionPrediction(example, selectedAttributes, coefficients, useIntercept);
            double diff = prediction - example.getLabel();
            error += diff * diff;
        }
        return error;
    }

    private double regressionPrediction(Example example, boolean[] selectedAttributes, double[] coefficients, boolean useIntercept) {
        double prediction = 0.0;
        int index = 0;
        int counter = 0;
        for (Attribute attribute : example.getAttributes()) {
            if (!selectedAttributes[counter++]) continue;
            prediction += coefficients[index] * example.getValue(attribute);
            ++index;
        }
        if (useIntercept) {
            prediction += coefficients[index];
        }
        return prediction;
    }

    private double[] performRegression(ExampleSet exampleSet, boolean[] selectedAttributes, double[] means, double labelMean) throws UndefinedParameterError {
        int currentlySelectedAttributes = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                ++currentlySelectedAttributes;
            }
            ++i;
        }
        Matrix independent = null;
        Matrix dependent = null;
        double[] weights = null;
        if (currentlySelectedAttributes > 0) {
            independent = new Matrix(exampleSet.size(), currentlySelectedAttributes);
            dependent = new Matrix(exampleSet.size(), 1);
            int exampleIndex = 0;
            Iterator i2 = exampleSet.iterator();
            weights = new double[exampleSet.size()];
            Attribute weightAttribute = exampleSet.getAttributes().getWeight();
            while (i2.hasNext()) {
                Example example = (Example)i2.next();
                int attributeIndex = 0;
                dependent.set(exampleIndex, 0, example.getLabel());
                int counter = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    if (selectedAttributes[counter]) {
                        double value = example.getValue(attribute) - means[counter];
                        independent.set(exampleIndex, attributeIndex, value);
                        ++attributeIndex;
                    }
                    ++counter;
                }
                weights[exampleIndex] = weightAttribute != null ? example.getValue(weightAttribute) : 1.0;
                ++exampleIndex;
            }
        }
        double[] coefficients = new double[currentlySelectedAttributes + 1];
        if (currentlySelectedAttributes > 0) {
            double[] coefficientsWithoutIntercept = com.rapidminer.tools.math.LinearRegression.performRegression(independent, dependent, weights, this.getParameterAsDouble(PARAMETER_RIDGE));
            System.arraycopy(coefficientsWithoutIntercept, 0, coefficients, 0, currentlySelectedAttributes);
        }
        coefficients[currentlySelectedAttributes] = labelMean;
        int coefficientIndex = 0;
        int i3 = 0;
        while (i3 < selectedAttributes.length) {
            if (selectedAttributes[i3]) {
                int n = coefficients.length - 1;
                coefficients[n] = coefficients[n] - coefficients[coefficientIndex] * means[i3];
                ++coefficientIndex;
            }
            ++i3;
        }
        return coefficients;
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc.equals(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        if (lc.equals(LearnerCapability.NUMERICAL_CLASS)) {
            return true;
        }
        if (lc.equals(LearnerCapability.BINOMINAL_CLASS)) {
            return true;
        }
        return lc == LearnerCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_FEATURE_SELECTION, "The feature selection method used during regression.", FEATURE_SELECTION_METHODS, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_ELIMINATE_COLINEAR_FEATURES, "Indicates if the algorithm should try to delete colinear features during the regression.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_BIAS, "Indicates if an intercept value should be calculated.", true));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_STANDARDIZED_COEFFICIENT, "The minimum standardized coefficient for the removal of colinear feature elimination.", 0.0, Double.POSITIVE_INFINITY, 1.5));
        types.add(new ParameterTypeDouble(PARAMETER_RIDGE, "The ridge parameter used during ridge regression.", 0.0, Double.POSITIVE_INFINITY, 1.0E-8));
        return types;
    }
}

