/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAttributeName
extends AbstractDataProcessing {
    public static final String PARAMETER_OLD_NAME = "old_name";
    public static final String PARAMETER_NEW_NAME = "new_name";

    public ChangeAttributeName(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String oldName = this.getParameterAsString(PARAMETER_OLD_NAME);
        Attribute attribute = exampleSet.getAttributes().get(oldName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, oldName);
        }
        String newName = this.getParameterAsString(PARAMETER_NEW_NAME);
        attribute.setName(newName);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_OLD_NAME, "The old name of the attribute.", false));
        types.add(new ParameterTypeString(PARAMETER_NEW_NAME, "The new name of the attribute.", false));
        return types;
    }
}

