/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalBinominalRemapping
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";
    public static final String PARAMETER_NEGATIVE_VALUE = "negative_value";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";

    public InternalBinominalRemapping(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String negativeValue = this.getParameterAsString(PARAMETER_NEGATIVE_VALUE);
        String positiveValue = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
        String attributeNameRegex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(attributeNameRegex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, attributeNameRegex, e.getMessage());
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> iterator = this.getParameterAsBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES) ? exampleSet.getAttributes().allAttributes() : exampleSet.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (matcher.matches() && attribute.isNominal()) {
                attributes.add(attribute);
            }
            this.checkForStop();
        }
        HashMap mappings = new HashMap();
        int i = 0;
        while (i < attributes.size()) {
            Attribute attribute = (Attribute)attributes.get(i);
            if (!negativeValue.equals(attribute.getMapping().getNegativeString()) || !positiveValue.equals(attribute.getMapping().getPositiveString())) {
                if (negativeValue.equals(attribute.getMapping().getPositiveString()) && positiveValue.equals(attribute.getMapping().getNegativeString())) {
                    HashMap<Double, Double> mapping = new HashMap<Double, Double>();
                    mapping.put(0.0, 1.0);
                    mapping.put(1.0, 0.0);
                    mappings.put(attribute, mapping);
                    attribute.getMapping().clear();
                    attribute.getMapping().mapString(negativeValue);
                    attribute.getMapping().mapString(positiveValue);
                } else {
                    this.logWarning("specified values do not match values of attribute " + attribute.getName() + ", attribute is skipped.");
                }
            }
            ++i;
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                Double mappedValue;
                double value;
                HashMap mapping = (HashMap)mappings.get(attribute);
                if (mapping == null || Double.isNaN(value = example.getValue(attribute)) || (mappedValue = (Double)mapping.get(value)) == null) continue;
                example.setValue(attribute, mappedValue);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "The attributes to which the mapping correction should be applied.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES, "Consider also special attributes (label, id...).", false));
        types.add(new ParameterTypeString(PARAMETER_NEGATIVE_VALUE, "The first/negative/false value.", false));
        types.add(new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "The second/positive/true value.", false));
        return types;
    }
}

