/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.http;

public class Address {
    private String host;
    private int port;
    private String fullAddress;
    private String httpAddress;

    public Address() {
        this("", "");
    }

    public Address(String hostIn, int portIn) {
        this(hostIn, String.valueOf(portIn));
    }

    public Address(String hostIn, String portIn) {
        this.init(hostIn, portIn);
    }

    public Address(String fullAddress) {
        String tmpAddress = fullAddress.trim();
        int index = tmpAddress.lastIndexOf(58);
        String hostIn = "";
        String portIn = "";
        if (index > 0) {
            hostIn = tmpAddress.substring(0, index);
            if (index + 1 < tmpAddress.length()) {
                portIn = tmpAddress.substring(index + 1);
            }
        } else {
            hostIn = tmpAddress;
        }
        this.init(hostIn, portIn);
    }

    public void init(String hostIn, String portIn) {
        this.host = hostIn;
        if (portIn != "") {
            this.port = Integer.valueOf(portIn);
            this.fullAddress = this.host + ":" + portIn;
        } else {
            this.port = Integer.MIN_VALUE;
            this.fullAddress = this.host;
        }
        this.httpAddress = this.fullAddress != null && this.fullAddress.length() > 0 ? "http://" + this.fullAddress : null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getFullAddress() {
        return this.fullAddress;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }
}

