/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.CellColorProviderAlternating;
import com.rapidminer.gui.tools.ColoredTableCellRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTableColumnFitMouseListener;
import com.rapidminer.gui.tools.ExtendedJTablePacker;
import com.rapidminer.gui.tools.ExtendedJTableSorterModel;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.actions.AddToSortingColumnsAction;
import com.rapidminer.gui.tools.actions.EqualColumnWidthsAction;
import com.rapidminer.gui.tools.actions.FitAllColumnWidthsAction;
import com.rapidminer.gui.tools.actions.FitColumnWidthAction;
import com.rapidminer.gui.tools.actions.RestoreOriginalColumnOrderAction;
import com.rapidminer.gui.tools.actions.SelectColumnAction;
import com.rapidminer.gui.tools.actions.SelectRowAction;
import com.rapidminer.gui.tools.actions.SortByColumnAction;
import com.rapidminer.gui.tools.actions.SortColumnsAccordingToNameAction;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ExtendedJTable
extends JTable
implements Tableable,
MouseListener {
    private static final long serialVersionUID = 4840252601155251257L;
    private static final int DEFAULT_MAX_ROWS_FOR_SORTING = 100000;
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int NO_DATE_FORMAT = -1;
    public static final int DATE_FORMAT = 0;
    public static final int TIME_FORMAT = 1;
    public static final int DATE_TIME_FORMAT = 2;
    private Action ROW_ACTION = new SelectRowAction(this, IconSize.SMALL);
    private Action COLUMN_ACTION = new SelectColumnAction(this, IconSize.SMALL);
    private Action FIT_COLUMN_ACTION = new FitColumnWidthAction(this, IconSize.SMALL);
    private Action FIT_ALL_COLUMNS_ACTION = new FitAllColumnWidthsAction(this, IconSize.SMALL);
    private Action EQUAL_WIDTHS_ACTION = new EqualColumnWidthsAction(this, IconSize.SMALL);
    private Action SORTING_DESCENDING_ACTION = new SortByColumnAction(this, -1, IconSize.SMALL);
    private Action SORTING_ASCENDING_ACTION = new SortByColumnAction(this, 1, IconSize.SMALL);
    private Action ADD_TO_SORTING_DESCENDING_ACTION = new AddToSortingColumnsAction(this, -1, IconSize.SMALL);
    private Action ADD_TO_SORTING_ASCENDING_ACTION = new AddToSortingColumnsAction(this, 1, IconSize.SMALL);
    private Action SORT_COLUMNS_BY_NAME_ACTION = new SortColumnsAccordingToNameAction(this, IconSize.SMALL);
    private Action RESTORE_COLUMN_ORDER_ACTION = new RestoreOriginalColumnOrderAction(this, IconSize.SMALL);
    private boolean sortable = true;
    private CellColorProvider cellColorProvider = new CellColorProviderAlternating();
    private boolean useColoredCellRenderer = true;
    private transient ColoredTableCellRenderer renderer = new ColoredTableCellRenderer();
    private ExtendedJTableSorterModel tableSorter = null;
    private ExtendedJScrollPane scrollPaneParent = null;
    private ExtendedJTablePacker packer = null;
    private boolean fixFirstColumn = false;
    private String[] originalOrder = null;
    private boolean showPopopUpMenu = true;

    public ExtendedJTable() {
        this(null, true);
    }

    public ExtendedJTable(boolean sortable) {
        this(null, sortable);
    }

    public ExtendedJTable(TableModel model, boolean sortable) {
        this(model, sortable, true);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable) {
        this(model, sortable, columnMovable, true);
    }

    public ExtendedJTable(boolean sortable, boolean columnMovable, boolean autoResize) {
        this(null, sortable, columnMovable, autoResize);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable, boolean autoResize) {
        this(model, sortable, columnMovable, autoResize, true, false);
    }

    public ExtendedJTable(TableModel model, boolean sortable, boolean columnMovable, boolean autoResize, boolean useColoredCellRenderer, boolean fixFirstColumn) {
        this.sortable = sortable;
        this.useColoredCellRenderer = useColoredCellRenderer;
        this.fixFirstColumn = fixFirstColumn;
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(columnMovable);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (!autoResize) {
            this.setAutoResizeMode(0);
        }
        if (model != null) {
            this.setModel(model);
        }
        this.getTableHeader().addMouseListener(new ExtendedJTableColumnFitMouseListener());
        this.addMouseListener(this);
    }

    protected Object readResolve() {
        this.renderer = new ColoredTableCellRenderer();
        return this;
    }

    protected ExtendedJTableSorterModel getTableSorter() {
        return this.tableSorter;
    }

    public int getDateFormat(int row, int column) {
        return -1;
    }

    public void setCellColorProvider(CellColorProvider cellColorProvider) {
        this.cellColorProvider = cellColorProvider;
    }

    public CellColorProvider getCellColorProvider() {
        return this.cellColorProvider;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setShowPopupMenu(boolean showPopupMenu) {
        this.showPopopUpMenu = showPopupMenu;
    }

    public void setFixFirstColumnForRearranging(boolean fixFirstColumn) {
        this.fixFirstColumn = fixFirstColumn;
    }

    public void setModel(TableModel model) {
        boolean shouldSort;
        boolean bl = shouldSort = this.sortable && this.checkIfSortable(model);
        if (shouldSort) {
            this.tableSorter = new ExtendedJTableSorterModel(model);
            this.tableSorter.setTableHeader(this.getTableHeader());
            super.setModel(this.tableSorter);
        } else {
            super.setModel(model);
            this.tableSorter = null;
        }
        this.originalOrder = new String[model.getColumnCount()];
        int c = 0;
        while (c < model.getColumnCount()) {
            this.originalOrder[c] = model.getColumnName(c);
            ++c;
        }
    }

    public void setSortingStatus(int status, boolean cancelSorting) {
        if (this.getModel() instanceof ExtendedJTableSorterModel) {
            int column;
            ExtendedJTableSorterModel sorterModel = (ExtendedJTableSorterModel)this.getModel();
            JTableHeader h = this.getTableHeader();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = this.getSelectedColumn();
            if (viewColumn != -1 && (column = columnModel.getColumn(viewColumn).getModelIndex()) != -1) {
                if (sorterModel.isSorting() && cancelSorting) {
                    sorterModel.cancelSorting();
                }
                sorterModel.setSortingStatus(column, status);
            }
        }
    }

    public void pack() {
        this.packer = new ExtendedJTablePacker(true);
        if (this.isShowing()) {
            this.packer.pack(this);
            this.packer = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.packer != null) {
            this.packer.pack(this);
            this.packer = null;
        }
    }

    public void unpack() {
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            int c = 0;
            while (c < this.getColumnCount()) {
                TableColumn tableColumn = header.getColumnModel().getColumn(c);
                header.setResizingColumn(tableColumn);
                int width = 100;
                if (this.getWidth() / width > this.getColumnCount()) {
                    width = this.getWidth() / this.getColumnCount();
                }
                tableColumn.setWidth(width);
                ++c;
            }
        }
    }

    public void packColumn() {
        TableColumn tableColumn;
        int col;
        JTableHeader header = this.getTableHeader();
        if (header != null && (col = this.getSelectedColumn()) >= 0 && (tableColumn = header.getColumnModel().getColumn(col)) != null) {
            int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(this, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            int firstRow = 0;
            int lastRow = this.getRowCount();
            ExtendedJScrollPane scrollPane = this.getExtendedScrollPane();
            if (scrollPane != null) {
                JViewport viewport = scrollPane.getViewport();
                Rectangle viewRect = viewport.getViewRect();
                if (viewport.getHeight() < this.getHeight()) {
                    firstRow = this.rowAtPoint(new Point(0, viewRect.y));
                    firstRow = Math.max(0, firstRow);
                    lastRow = this.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                    lastRow = Math.min(lastRow, this.getRowCount());
                }
            }
            int row = firstRow;
            while (row < lastRow) {
                int preferedWidth = (int)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
                ++row;
            }
            header.setResizingColumn(tableColumn);
            tableColumn.setWidth(width + this.getIntercellSpacing().width);
        }
    }

    public void sortColumnsAccordingToNames() {
        int offset = 0;
        if (this.fixFirstColumn) {
            offset = 1;
        }
        int i = offset;
        while (i < this.getColumnCount()) {
            int minIndex = -1;
            String minName = null;
            int j = i;
            while (j < this.getColumnCount()) {
                String currentName = this.getColumnName(j);
                if (minName == null || currentName.compareTo(minName) < 0) {
                    minName = currentName;
                    minIndex = j;
                }
                ++j;
            }
            this.moveColumn(minIndex, i);
            ++i;
        }
    }

    public void restoreOriginalColumnOrder() {
        int i = 0;
        while (i < this.originalOrder.length) {
            String nextColumn = this.originalOrder[i];
            int j = i;
            while (j < this.getColumnCount()) {
                String candidateName = this.getColumnName(j);
                if (nextColumn.equals(candidateName)) {
                    this.moveColumn(j, i);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public Dimension getIntercellSpacing() {
        Dimension dimension = super.getIntercellSpacing();
        dimension.width += 6;
        return dimension;
    }

    private boolean checkIfSortable(TableModel model) {
        int maxSortableRows = 100000;
        String maxString = System.getProperty("rapidminer.gui.max_sortable_rows");
        if (maxString != null) {
            try {
                maxSortableRows = Integer.parseInt(maxString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return model.getRowCount() <= maxSortableRows;
    }

    public void columnMoved(TableColumnModelEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMoved(e);
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMarginChanged(e);
    }

    public boolean shouldUseColoredCellRenderer() {
        return this.useColoredCellRenderer;
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        if (this.useColoredCellRenderer) {
            Color color = null;
            CellColorProvider usedColorProvider = this.getCellColorProvider();
            if (usedColorProvider != null) {
                color = usedColorProvider.getCellColor(row, col);
            }
            if (color != null) {
                this.renderer.setColor(color);
            }
            this.renderer.setDateFormat(this.getDateFormat(row, col));
            return this.renderer;
        }
        return super.getCellRenderer(row, col);
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        int rowIndex = this.rowAtPoint(p);
        Object value = this.getModel().getValueAt(rowIndex, realColumnIndex);
        String text = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            double numberValue = number.doubleValue();
            text = Tools.formatIntegerIfPossible(numberValue);
        } else if (value != null) {
            if (value instanceof Date) {
                int dateFormat = this.getDateFormat(rowIndex, realColumnIndex);
                switch (dateFormat) {
                    case 0: {
                        text = Tools.formatDate((Date)value);
                        break;
                    }
                    case 1: {
                        text = Tools.formatTime((Date)value);
                        break;
                    }
                    case 2: {
                        text = Tools.formatDateTime((Date)value);
                        break;
                    }
                    default: {
                        text = value.toString();
                        break;
                    }
                }
            } else {
                text = value.toString();
            }
        } else {
            text = "?";
        }
        if (text != null) {
            return SwingTools.transformToolTipText(text);
        }
        return super.getToolTipText();
    }

    public String getCell(int row, int column) {
        Object value;
        String text = null;
        if (this.getTableHeader() != null) {
            if (row == 0) {
                return this.getTableHeader().getColumnModel().getColumn(column).getHeaderValue().toString();
            }
            --row;
        }
        if ((value = this.getModel().getValueAt(row, column)) instanceof Number) {
            Number number = (Number)value;
            double numberValue = number.doubleValue();
            text = Tools.formatIntegerIfPossible(numberValue);
        } else {
            text = value != null ? value.toString() : "?";
        }
        return text;
    }

    public int getColumnNumber() {
        return this.getColumnCount();
    }

    public int getRowNumber() {
        if (this.getTableHeader() != null) {
            return this.getRowCount() + 1;
        }
        return this.getRowCount();
    }

    public void prepareReporting() {
    }

    public void finishReporting() {
    }

    public boolean isFirstLineHeader() {
        return false;
    }

    public boolean isFirstColumnHeader() {
        return false;
    }

    public int getModelIndex(int rowIndex) {
        return this.tableSorter.modelIndex(rowIndex);
    }

    public void setExtendedScrollPane(ExtendedJScrollPane scrollPane) {
        this.scrollPaneParent = scrollPane;
    }

    public ExtendedJScrollPane getExtendedScrollPane() {
        return this.scrollPaneParent;
    }

    public void selectCompleteRow() {
        this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
    }

    public void selectCompleteColumn() {
        this.addRowSelectionInterval(0, this.getRowCount() - 1);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.showPopopUpMenu && e.isPopupTrigger()) {
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int c = this.columnAtPoint(p);
            int column = this.convertColumnIndexToModel(c);
            this.setRowSelectionInterval(row, row);
            this.setColumnSelectionInterval(column, column);
            JPopupMenu menu = new JPopupMenu();
            menu.add(this.ROW_ACTION);
            menu.add(this.COLUMN_ACTION);
            if (this.getTableHeader() != null) {
                menu.addSeparator();
                menu.add(this.FIT_COLUMN_ACTION);
                menu.add(this.FIT_ALL_COLUMNS_ACTION);
                menu.add(this.EQUAL_WIDTHS_ACTION);
            }
            if (this.isSortable()) {
                menu.addSeparator();
                menu.add(this.SORTING_ASCENDING_ACTION);
                menu.add(this.SORTING_DESCENDING_ACTION);
                menu.addSeparator();
                menu.add(this.ADD_TO_SORTING_ASCENDING_ACTION);
                menu.add(this.ADD_TO_SORTING_DESCENDING_ACTION);
            }
            if (this.getTableHeader() != null && this.getTableHeader().getReorderingAllowed()) {
                menu.addSeparator();
                menu.add(this.SORT_COLUMNS_BY_NAME_ACTION);
                menu.add(this.RESTORE_COLUMN_ORDER_ACTION);
            }
            menu.show(this, e.getX(), e.getY());
        }
    }
}

