/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.GHAModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHA
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_NUMBER_OF_ITERATIONS = "number_of_iterations";
    public static final String PARAMETER_LEARNING_RATE = "learning_rate";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public GHA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) {
                throw new UserError((Operator)this, 104, "GHA", attribute.getName());
            }
            means[a] = exampleSet.getStatistics(attribute, "average");
            ++a;
        }
        this.log("Initialising the weight matrix...");
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < exampleSet.size()) {
            Example example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - means[d];
                ++d;
            }
            this.checkForStop();
            ++sample;
        }
        double learningRate = this.getParameterAsDouble(PARAMETER_LEARNING_RATE);
        int numberOfComponents = this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS);
        if (numberOfComponents < 0) {
            numberOfComponents = exampleSet.getAttributes().size();
        }
        int numberOfIterations = this.getParameterAsInt(PARAMETER_NUMBER_OF_ITERATIONS);
        double[][] randomMatrix = new double[numberOfComponents][exampleSet.getAttributes().size()];
        int i = 0;
        while (i < randomMatrix.length) {
            int j = 0;
            while (j < randomMatrix[i].length) {
                randomMatrix[i][j] = random.nextDouble();
                ++j;
            }
            ++i;
        }
        Matrix W = new Matrix(randomMatrix);
        W.timesEquals(0.1);
        this.log("Training with learning rate: " + learningRate);
        this.train(data, W, numberOfIterations, learningRate, random);
        this.log("Creating the model...");
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        Matrix tmp = W.times(covarianceMatrix);
        double[][] weights = W.getArray();
        double[][] tmparray = tmp.getArray();
        double[] eigenvalues = new double[numberOfComponents];
        int i2 = 0;
        while (i2 < weights.length) {
            double nr = 0.0;
            eigenvalues[i2] = 0.0;
            int j = 0;
            while (j < weights[0].length) {
                tmparray[i2][j] = tmparray[i2][j] / weights[i2][j];
                if (tmparray[i2][j] > 0.0) {
                    nr += 1.0;
                    int n = i2;
                    eigenvalues[n] = eigenvalues[n] + tmparray[i2][j];
                }
                ++j;
            }
            nr = Math.max(nr, 1.0);
            eigenvalues[i2] = eigenvalues[i2] / nr;
            ++i2;
        }
        GHAModel model = new GHAModel(exampleSet, eigenvalues, W.getArray(), means);
        return new IOObject[]{exampleSet, model};
    }

    private void train(double[][] data, Matrix W, int numberOfIterations, double learningRate, Random random) throws OperatorException {
        int iterlog = 1;
        while (numberOfIterations / iterlog > 10 && numberOfIterations / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        int iter = 1;
        while (iter <= numberOfIterations) {
            if (iter % iterlog == 0) {
                this.log("Iteration " + iter);
            }
            int sample = (int)(random.nextDouble() * (double)data.length);
            Matrix x = new Matrix(data[sample], data[sample].length);
            Matrix y = W.times(x);
            double[][] yyT = y.times(y.transpose()).getArray();
            int row = 0;
            while (row < yyT.length) {
                int col = row + 1;
                while (col < yyT.length) {
                    yyT[row][col] = 0.0;
                    ++col;
                }
                ++row;
            }
            Matrix LT = new Matrix(yyT);
            Matrix tmp1 = y.times(x.transpose());
            Matrix tmp2 = LT.times(W);
            tmp1 = tmp1.minus(tmp2);
            tmp1.timesEquals(learningRate);
            W.plusEquals(tmp1);
            double[][] w = W.getArray();
            int i = 0;
            while (i < w.length) {
                int j = 0;
                while (j < w[0].length) {
                    if (Double.isInfinite(w[i][j]) || Double.isNaN(w[i][j])) {
                        throw new OperatorException("Lost convergence at iterator " + (iter + 1) + ". Lower learning rate?");
                    }
                    ++j;
                }
                ++i;
            }
            this.checkForStop();
            ++iter;
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Number of components to compute. If '-1' nr of attributes is taken.'", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_ITERATIONS, "Number of Iterations to apply the update rule.", 0, Integer.MAX_VALUE, 10);
        list.add(type);
        type = new ParameterTypeDouble(PARAMETER_LEARNING_RATE, "The learning rate for GHA (small)", 0.0, Double.POSITIVE_INFINITY, 0.01);
        list.add(type);
        list.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "The local random seed for this operator, uses global random number generator if -1.", -1, Integer.MAX_VALUE, -1));
        return list;
    }
}

