/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.ActivationFunction;
import com.rapidminer.operator.learner.functions.neuralnet.InnerNode;
import com.rapidminer.operator.learner.functions.neuralnet.Node;

public class LinearFunction
extends ActivationFunction {
    public String getTypeName() {
        return "Linear";
    }

    public double calculateValue(InnerNode node, Example example) {
        Node[] inputs = node.getInputNodes();
        double[] weights = node.getWeights();
        double weightedSum = weights[0];
        int i = 0;
        while (i < inputs.length) {
            weightedSum += inputs[i].calculateValue(true, example) * weights[i + 1];
            ++i;
        }
        return weightedSum;
    }

    public double calculateError(InnerNode node, Example example) {
        Node[] outputs = node.getOutputNodes();
        int[] numberOfOutputs = node.getOutputNodeInputIndices();
        double errorSum = 0.0;
        int i = 0;
        while (i < outputs.length) {
            errorSum += outputs[i].calculateError(true, example) * outputs[i].getWeight(numberOfOutputs[i]);
            ++i;
        }
        return errorSum;
    }
}

