/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAttributeNamesReplace
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_REPLACE_WHAT = "replace_what";
    public static final String PARAMETER_REPLACE_BY = "replace_by";
    public static final String PARAMETER_APPLY_ON_SPECIAL = "apply_on_special";

    public ChangeAttributeNamesReplace(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Pattern attributeFilter = Pattern.compile(this.getParameterAsString(PARAMETER_ATTRIBUTES));
        String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
        String replaceBy = "";
        if (this.isParameterSet(PARAMETER_REPLACE_BY)) {
            replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
        }
        Pattern whatPattern = Pattern.compile(replaceWhat);
        if (this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL)) {
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute attribute = a.next();
                String name = attribute.getName();
                if (!attributeFilter.matcher(name).matches()) continue;
                Matcher whatMatcher = whatPattern.matcher(name);
                String newName = whatMatcher.replaceAll(replaceBy);
                attribute.setName(newName);
            }
        } else {
            for (Attribute attribute : exampleSet.getAttributes()) {
                String name = attribute.getName();
                if (!attributeFilter.matcher(name).matches()) continue;
                Matcher whatMatcher = whatPattern.matcher(name);
                String newName = whatMatcher.replaceAll(replaceBy);
                attribute.setName(newName);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "A regular expression defining a filter for the attribute names for which the replace operation should be performed.", ".*"));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_REPLACE_WHAT, "A regular expression defining what should be replaced in the attribute names.", "\\W");
        type.setShowRange(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_REPLACE_BY, "This string is used as replacement for all parts of the matching attributes where the parameter 'replace_what' matches.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_SPECIAL, "Indicates if this name replacement should also be performed for special attributes.", true));
        return types;
    }
}

