/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.preprocessing.discretization.BinDiscretization;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.ContingencyTableTools;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricalUncertaintyOperator
extends AbstractWeighting {
    public SymmetricalUncertaintyOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "symmetrical uncertainty", label.getName());
        }
        BinDiscretization discretization = null;
        try {
            discretization = OperatorService.createOperator(BinDiscretization.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "Discretization", e.getMessage());
        }
        int numberOfBins = this.getParameterAsInt("number_of_bins");
        discretization.setParameter("number_of_bins", String.valueOf(numberOfBins));
        IOContainer ioContainer = new IOContainer(exampleSet);
        ioContainer = discretization.apply(ioContainer);
        exampleSet = ioContainer.get(ExampleSet.class);
        AttributeWeights weights = new AttributeWeights(exampleSet);
        for (Attribute attribute : exampleSet.getAttributes()) {
            double[][] counters = new double[attribute.getMapping().size()][label.getMapping().size()];
            for (Example example : exampleSet) {
                double[] dArray = counters[(int)example.getValue(attribute)];
                int n = (int)example.getLabel();
                dArray[n] = dArray[n] + 1.0;
            }
            double weight = ContingencyTableTools.symmetricalUncertainty(counters);
            weights.setWeight(attribute.getName(), weight);
        }
        return weights;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("number_of_bins", "The number of bins used for discretization of numerical attributes before the chi squared test can be performed.", 2, Integer.MAX_VALUE, 10));
        return types;
    }
}

