/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.lazy.AttributeBasedVotingModel;

public class AttributeBasedVotingLearner
extends AbstractLearner {
    public AttributeBasedVotingLearner(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) {
        exampleSet.recalculateAttributeStatistics(exampleSet.getAttributes().getLabel());
        double majorityPrediction = exampleSet.getAttributes().getLabel().isNominal() ? exampleSet.getStatistics(exampleSet.getAttributes().getLabel(), "mode") : exampleSet.getStatistics(exampleSet.getAttributes().getLabel(), "average");
        return new AttributeBasedVotingModel(exampleSet, majorityPrediction);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }
}

