/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.join.AbstractExampleSetJoin;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetJoin
extends AbstractExampleSetJoin {
    public static final String PARAMETER_JOIN_TYPE = "join_type";
    public static final String[] JOIN_TYPES = new String[]{"inner", "left", "right", "outer"};
    public static final int JOIN_TYPE_INNER = 0;
    public static final int JOIN_TYPE_LEFT = 1;
    public static final int JOIN_TYPE_RIGHT = 2;
    public static final int JOIN_TYPE_OUTER = 3;

    public ExampleSetJoin(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MemoryExampleTable joinData(ExampleSet leftExampleSet, ExampleSet rightExampleSet, List<AbstractExampleSetJoin.AttributeSource> originalAttributeSources, List<Attribute> unionAttributeList) throws OperatorException {
        int joinType = this.getParameterAsInt(PARAMETER_JOIN_TYPE);
        leftExampleSet.remapIds();
        rightExampleSet.remapIds();
        Attribute leftIdAttribute = leftExampleSet.getAttributes().getId();
        Attribute rightIdAttribute = rightExampleSet.getAttributes().getId();
        MemoryExampleTable unionTable = new MemoryExampleTable(unionAttributeList);
        switch (joinType) {
            case 0: {
                for (Example leftExample : leftExampleSet) {
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        int[] nArray = rightExampleIndices;
                        int n = rightExampleIndices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int rightExampleIndex = nArray[n2];
                            Example rightExample = rightExampleSet.getExample(rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                            ++n2;
                        }
                    }
                    this.checkForStop();
                }
                break;
            }
            case 1: {
                for (Example leftExample : leftExampleSet) {
                    Object object;
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        object = rightExampleIndices;
                        int n = rightExampleIndices.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object rightExampleIndex = object[n3];
                            Example rightExample = rightExampleSet.getExample((int)rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                                if (attributeSource.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                                } else if (attributeSource.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                            ++n3;
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        object = originalAttributeSources.iterator();
                        while (object.hasNext()) {
                            AbstractExampleSetJoin.AttributeSource attributeSource = (AbstractExampleSetJoin.AttributeSource)object.next();
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = Double.NaN;
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                break;
            }
            case 2: {
                for (Example rightExample : rightExampleSet) {
                    int attributeIndex;
                    Object object;
                    double rightIdValue = rightExample.getValue(rightIdAttribute);
                    int[] leftExampleIndices = null;
                    leftExampleIndices = rightIdAttribute.isNominal() ? leftExampleSet.getExampleIndicesFromId(leftIdAttribute.getMapping().getIndex(rightIdAttribute.getMapping().mapIndex((int)rightIdValue))) : leftExampleSet.getExampleIndicesFromId(rightIdValue);
                    if (leftExampleIndices != null) {
                        object = leftExampleIndices;
                        int attributeSource = leftExampleIndices.length;
                        attributeIndex = 0;
                        while (attributeIndex < attributeSource) {
                            Object leftExampleIndex = object[attributeIndex];
                            Example leftExample = leftExampleSet.getExample((int)leftExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex2 = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource2 : originalAttributeSources) {
                                if (attributeSource2.getSource() == 1) {
                                    unionDataRow[attributeIndex2] = leftExample.getValue(attributeSource2.getAttribute());
                                } else if (attributeSource2.getSource() == 2) {
                                    unionDataRow[attributeIndex2] = rightExample.getValue(attributeSource2.getAttribute());
                                }
                                ++attributeIndex2;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                            ++attributeIndex;
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        attributeIndex = 0;
                        object = originalAttributeSources.iterator();
                        while (object.hasNext()) {
                            AbstractExampleSetJoin.AttributeSource attributeSource = (AbstractExampleSetJoin.AttributeSource)object.next();
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = attributeSource.getAttribute() == leftIdAttribute ? rightExample.getValue(rightIdAttribute) : Double.NaN;
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                break;
            }
            case 3: {
                HashSet<Integer> mappedRightExampleIndices = new HashSet<Integer>();
                for (Example leftExample : leftExampleSet) {
                    Object object;
                    double leftIdValue = leftExample.getValue(leftIdAttribute);
                    int[] rightExampleIndices = null;
                    rightExampleIndices = leftIdAttribute.isNominal() ? rightExampleSet.getExampleIndicesFromId(rightIdAttribute.getMapping().getIndex(leftIdAttribute.getMapping().mapIndex((int)leftIdValue))) : rightExampleSet.getExampleIndicesFromId(leftIdValue);
                    if (rightExampleIndices != null) {
                        object = rightExampleIndices;
                        int n = rightExampleIndices.length;
                        int attributeSource = 0;
                        while (attributeSource < n) {
                            Object rightExampleIndex = object[attributeSource];
                            mappedRightExampleIndices.add((int)rightExampleIndex);
                            Example rightExample = rightExampleSet.getExample((int)rightExampleIndex);
                            double[] unionDataRow = new double[unionAttributeList.size()];
                            int attributeIndex = 0;
                            for (AbstractExampleSetJoin.AttributeSource attributeSource3 : originalAttributeSources) {
                                if (attributeSource3.getSource() == 1) {
                                    unionDataRow[attributeIndex] = leftExample.getValue(attributeSource3.getAttribute());
                                } else if (attributeSource3.getSource() == 2) {
                                    unionDataRow[attributeIndex] = rightExample.getValue(attributeSource3.getAttribute());
                                }
                                ++attributeIndex;
                            }
                            unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                            ++attributeSource;
                        }
                    } else {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        object = originalAttributeSources.iterator();
                        while (object.hasNext()) {
                            AbstractExampleSetJoin.AttributeSource attributeSource = (AbstractExampleSetJoin.AttributeSource)object.next();
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = leftExample.getValue(attributeSource.getAttribute());
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = Double.NaN;
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    this.checkForStop();
                }
                int rightExampleIndex = 0;
                for (Example rightExample : rightExampleSet) {
                    if (!mappedRightExampleIndices.contains(rightExampleIndex)) {
                        double[] unionDataRow = new double[unionAttributeList.size()];
                        int attributeIndex = 0;
                        for (AbstractExampleSetJoin.AttributeSource attributeSource : originalAttributeSources) {
                            if (attributeSource.getSource() == 1) {
                                unionDataRow[attributeIndex] = attributeSource.getAttribute() == leftIdAttribute ? rightExample.getValue(rightIdAttribute) : Double.NaN;
                            } else if (attributeSource.getSource() == 2) {
                                unionDataRow[attributeIndex] = rightExample.getValue(attributeSource.getAttribute());
                            }
                            ++attributeIndex;
                        }
                        unionTable.addDataRow(new DoubleArrayDataRow(unionDataRow));
                    }
                    ++rightExampleIndex;
                    this.checkForStop();
                }
                break;
            }
        }
        return unionTable;
    }

    @Override
    protected boolean isIdNeeded() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_JOIN_TYPE, "Specifies which join should be executed.", JOIN_TYPES, 0));
        return types;
    }
}

