/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class TextSourceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -17872022872313061L;
    List<String[]> entries = new LinkedList<String[]>();

    TextSourceTableModel() {
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return "class name";
            }
            case 1: {
                return "source directory";
            }
            case 2: {
                return "#texts";
            }
        }
        return null;
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String[] row = this.entries.get(rowIndex);
        return row[columnIndex];
    }

    public void addRow(String className, File dir) {
        if (!dir.exists()) {
            JOptionPane.showMessageDialog(null, "The directory " + dir.getAbsolutePath() + " does not exist or is not accessible at the moment.");
            return;
        }
        int numFiles = 0;
        int numDirectories = 0;
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                ++numFiles;
            } else {
                ++numDirectories;
            }
            ++i;
        }
        if (numDirectories > 0) {
            JOptionPane.showMessageDialog(null, "The directory " + dir.getAbsolutePath() + " contains subdirectories. These directories will be ignored");
        }
        if (numFiles == 0) {
            JOptionPane.showMessageDialog(null, "The directory " + dir.getAbsolutePath() + " does not contain any files.");
        }
        this.entries.add(new String[]{className, dir.getAbsolutePath(), "" + numFiles});
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    public void delRow(int rowIndex) {
        this.entries.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }
}

