/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.Collections;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderCrossValidator {
    private final String languageCode;
    private final int cutoff;
    private final int iterations;
    private FMeasure fmeasure = new FMeasure();

    public TokenNameFinderCrossValidator(String languageCode, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.cutoff = cutoff;
        this.iterations = iterations;
    }

    public void evaluate(ObjectStream<NameSample> samples, int nFolds) throws IOException, InvalidFormatException, IOException {
        CrossValidationPartitioner<NameSample> partitioner = new CrossValidationPartitioner<NameSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<NameSample> trainingSampleStream = partitioner.next();
            TokenNameFinderModel model = NameFinderME.train(this.languageCode, null, trainingSampleStream, Collections.<String, Object>emptyMap(), this.cutoff, this.iterations);
            TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model));
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

