/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class AnovaCalculatorDialog
extends JDialog {
    private static final long serialVersionUID = 3023267244921354296L;
    private transient AnovaCalculator calculator = new AnovaCalculator();
    private JTextField alphaField = new JTextField("0.05");
    private AnovaTableModel tableModel;

    public AnovaCalculatorDialog(Frame owner) {
        super(owner, "Anova Calculator", false);
        this.calculator = new AnovaCalculator();
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new AnovaTableModel();
        ExtendedJTable dataTable = new ExtendedJTable((TableModel)this.tableModel, false);
        this.getContentPane().add((Component)new ExtendedJScrollPane(dataTable), "Center");
        JPanel inputPanel = new JPanel(new FlowLayout());
        JLabel label = new JLabel("Mean:");
        inputPanel.add(label);
        final JTextField meanField = new JTextField(8);
        inputPanel.add(meanField);
        label = new JLabel("Variance:");
        inputPanel.add(label);
        final JTextField varianceField = new JTextField(8);
        inputPanel.add(varianceField);
        label = new JLabel("Number:");
        inputPanel.add(label);
        final JTextField numberField = new JTextField(8);
        inputPanel.add(numberField);
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double mean = Double.NaN;
                String meanString = meanField.getText();
                if (meanString != null && meanString.trim().length() > 0) {
                    try {
                        mean = Double.parseDouble(meanString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'mean' must contain a real-valued number.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'mean' must contain a real-valued number.");
                    return;
                }
                double variance = Double.NaN;
                String varianceString = varianceField.getText();
                if (varianceString != null && varianceString.trim().length() > 0) {
                    try {
                        variance = Double.parseDouble(varianceString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'variance' must contain a real-valued number.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'variance' must contain a real-valued number.");
                    return;
                }
                int number = -1;
                String numberString = numberField.getText();
                if (numberString != null && numberString.trim().length() > 0) {
                    try {
                        number = Integer.parseInt(numberString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'number' must contain a positive integer number > 1.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'number' must contain a positive integer number > 1.");
                    return;
                }
                if (!Double.isNaN(mean) && !Double.isNaN(variance) && number > 1) {
                    AnovaCalculatorDialog.this.tableModel.addRow(new Object[]{mean, variance, number});
                }
            }
        });
        inputPanel.add(addButton);
        this.getContentPane().add((Component)inputPanel, "North");
        Box buttonPanel = new Box(0);
        JLabel alphaLabel = new JLabel("Significance Level: ");
        buttonPanel.add(alphaLabel);
        buttonPanel.add(this.alphaField);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton calculateButton = new JButton("Calculate...");
        calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AnovaCalculatorDialog.this.calculateANOVA();
                }
                catch (SignificanceCalculationException e1) {
                    SwingTools.showSimpleErrorMessage("Cannot calculate ANOVA: ", e1);
                }
            }
        });
        buttonPanel.add(calculateButton);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnovaCalculatorDialog.this.clearData();
            }
        });
        buttonPanel.add(clearButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnovaCalculatorDialog.this.close();
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(600, 400);
        this.setLocationRelativeTo(owner);
    }

    protected Object readResolve() {
        this.calculator = new AnovaCalculator();
        return this;
    }

    private void close() {
        this.dispose();
    }

    private void clearData() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
    }

    private void calculateANOVA() throws SignificanceCalculationException {
        double alpha = -1.0;
        String alphaString = this.alphaField.getText();
        try {
            alpha = Double.parseDouble(alphaString);
        }
        catch (NumberFormatException e) {
            SwingTools.showVerySimpleErrorMessage("Significance level must be a number between 0 and 1.");
        }
        if (alpha < 0.0 || alpha > 1.0) {
            SwingTools.showVerySimpleErrorMessage("Significance level must be a number between 0 and 1.");
        } else {
            this.calculator.clearGroups();
            this.calculator.setAlpha(alpha);
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                int number = (Integer)this.tableModel.getValueAt(i, 2);
                double mean = (Double)this.tableModel.getValueAt(i, 0);
                double variance = (Double)this.tableModel.getValueAt(i, 1);
                this.calculator.addGroup(number, mean, variance);
                ++i;
            }
            if (this.tableModel.getRowCount() < 2) {
                SwingTools.showVerySimpleErrorMessage("You need to add at least two rows in order to calculate an ANOVA test.");
                return;
            }
            SignificanceTestResult result = this.calculator.performSignificanceTest();
            JOptionPane.showMessageDialog(this, result.getVisualizationComponent(null), "ANOVA result", -1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnovaTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -2904775003271582149L;

        public AnovaTableModel() {
            super(new String[]{"Mean", "Variance", "Number"}, 0);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Integer.class;
            }
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

