/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStratifiedSampling
extends AbstractSamplingOperator {
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public AbstractStratifiedSampling(OperatorDescription description) {
        super(description);
    }

    public abstract double getRatio(ExampleSet var1) throws OperatorException;

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        SplittedExampleSet splittedExampleSet = new SplittedExampleSet(exampleSet, this.getRatio(exampleSet), 2, this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        splittedExampleSet.selectSingleSubset(0);
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        for (Example example : splittedExampleSet) {
            dataList.add(example.getDataRow());
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(splittedExampleSet.getExampleTable().getAttributes());
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

