/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import java.util.Arrays;
import marytts.signalproc.process.CopyingDataProcessor;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.signalproc.window.BartlettWindow;
import marytts.signalproc.window.BlackmanWindow;
import marytts.signalproc.window.FlattopWindow;
import marytts.signalproc.window.GaussWindow;
import marytts.signalproc.window.HammingWindow;
import marytts.signalproc.window.HanningWindow;
import marytts.signalproc.window.RectWindow;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;

public abstract class Window
implements CopyingDataProcessor,
InlineDataProcessor {
    public static final int RECT = 0;
    public static final int HAMMING = 1;
    public static final int BLACKMAN = 2;
    public static final int HANNING = 3;
    public static final int GAUSS = 4;
    public static final int BARTLETT = 5;
    public static final int FLATTOP = 6;
    protected double prescalingFactor;
    protected boolean evenLength;
    protected double[] window;

    protected Window() {
        this.prescalingFactor = 1.0;
    }

    public Window(int length) {
        this(length, 1.0);
    }

    public Window(int length, double prescalingFactor) {
        this.window = new double[length];
        this.evenLength = length % 2 == 0;
        this.prescalingFactor = prescalingFactor;
        this.initialise();
    }

    public double[] apply(double[] src, int pos) {
        double[] target = new double[this.window.length];
        this.apply(src, pos, target, 0);
        return target;
    }

    public double[] apply(double[] src) {
        return this.apply(src, 0);
    }

    @Override
    public void applyInline(double[] data, int pos, int len) {
        this.apply(data, pos, data, pos, len);
    }

    public void applyInline(double[] data, int pos) {
        this.applyInline(data, pos, this.window.length);
    }

    public void applyInline(double[] data) {
        this.applyInline(data, 0, this.window.length);
    }

    public void apply(double[] src, int srcPos, double[] target, int targetPos) {
        this.apply(src, srcPos, target, targetPos, 0, this.window.length);
    }

    @Override
    public void apply(double[] src, int srcPos, double[] target, int targetPos, int len) {
        this.apply(src, srcPos, target, targetPos, 0, len);
    }

    public void apply(double[] src, int srcPos, double[] target, int targetPos, int off, int len) {
        int end;
        if (len < 0 || off < 0 || off + len > this.window.length) {
            throw new IllegalArgumentException("Requested offset " + off + " or length " + len + " does not fit into window length " + this.window.length);
        }
        if (target.length < targetPos + len) {
            throw new IllegalArgumentException("Target array cannot hold enough data");
        }
        int start = srcPos;
        if (start < 0) {
            start = 0;
            Arrays.fill(target, targetPos, targetPos + (start - srcPos), 0.0);
        }
        if ((end = srcPos + len) > src.length) {
            end = src.length;
            Arrays.fill(target, targetPos + end - srcPos, targetPos + len, 0.0);
        }
        for (int i = start; i < end; ++i) {
            target[targetPos + i - srcPos] = src[i] * this.window[off + i - srcPos];
        }
    }

    protected abstract void initialise();

    public int getLength() {
        if (this.window == null) {
            throw new NullPointerException("The window has not yet been initialised");
        }
        return this.window.length;
    }

    public double value(int i) {
        if (this.window == null) {
            throw new NullPointerException("The window has not yet been initialised");
        }
        if (i < 0 || i > this.window.length) {
            throw new IllegalArgumentException("Can only return values for index positions 0 to " + this.window.length);
        }
        return this.window[i];
    }

    public int type() {
        if (this instanceof RectWindow) {
            return 0;
        }
        if (this instanceof HammingWindow) {
            return 1;
        }
        if (this instanceof BlackmanWindow) {
            return 2;
        }
        if (this instanceof HanningWindow) {
            return 3;
        }
        if (this instanceof GaussWindow) {
            return 4;
        }
        if (this instanceof BartlettWindow) {
            return 5;
        }
        if (this instanceof FlattopWindow) {
            return 6;
        }
        return -1;
    }

    public static Window get(int windowType, int length) {
        return Window.get(windowType, length, 1.0);
    }

    public static Window get(int windowType, int length, double prescale) {
        switch (windowType) {
            case 0: {
                return new RectWindow(length, prescale);
            }
            case 1: {
                return new HammingWindow(length, prescale);
            }
            case 2: {
                return new BlackmanWindow(length, prescale);
            }
            case 3: {
                return new HanningWindow(length, prescale);
            }
            case 4: {
                return new GaussWindow(length, prescale);
            }
            case 5: {
                return new BartlettWindow(length, prescale);
            }
            case 6: {
                return new FlattopWindow(length, prescale);
            }
        }
        throw new IllegalArgumentException("Unknown window type requested.");
    }

    public static int[] getAvailableTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public static int getTypeByName(String typeName) {
        String tomatch = typeName.toUpperCase();
        if (tomatch.startsWith("HAMMING")) {
            return 1;
        }
        if (tomatch.startsWith("RECT")) {
            return 0;
        }
        if (tomatch.startsWith("BLACKMAN")) {
            return 2;
        }
        if (tomatch.startsWith("HANNING")) {
            return 3;
        }
        if (tomatch.startsWith("GAUSS")) {
            return 4;
        }
        if (tomatch.startsWith("BARTLETT")) {
            return 5;
        }
        if (tomatch.startsWith("FLATTOP")) {
            return 6;
        }
        return -1;
    }

    public static String getTypeName(int windowType) {
        Window w = Window.get(windowType, 1);
        return w.toString();
    }

    public void normalize() {
        this.normalize(1.0f);
    }

    public void normalizePeakValue(float desiredPeakValue) {
        double maxVal = MathUtils.getMax(this.window);
        double scale = (double)desiredPeakValue / maxVal;
        int i = 0;
        while (i < this.window.length) {
            int n = i++;
            this.window[n] = this.window[n] * scale;
        }
    }

    public void normalize(float val) {
        int i;
        float total = 0.0f;
        for (i = 0; i < this.window.length; ++i) {
            total = (float)((double)total + this.window[i]);
        }
        float scale = val / total;
        i = 0;
        while (i < this.window.length) {
            int n = i++;
            this.window[n] = this.window[n] * (double)scale;
        }
    }

    public void normalizeSquaredSum(float val) {
        int i;
        float total = 0.0f;
        for (i = 0; i < this.window.length; ++i) {
            total = (float)((double)total + this.window[i] * this.window[i]);
        }
        float scale = (float)(Math.sqrt(val) / Math.sqrt(total));
        i = 0;
        while (i < this.window.length) {
            int n = i++;
            this.window[n] = this.window[n] * (double)scale;
        }
    }

    public void normalizeRange(float minVal, float maxVal) {
        MathUtils.adjustRange(this.window, minVal, maxVal);
    }

    public double[] getCoeffs() {
        return this.window;
    }

    public double[] getCoeffsLeftHalf() {
        return ArrayUtils.subarray(this.window, 0, (int)Math.floor(0.5 * (double)this.window.length + 0.5));
    }

    public double[] getCoeffsRightHalf() {
        int off = (int)Math.floor(0.5 * (double)this.window.length + 0.5);
        int len = this.window.length - off;
        return ArrayUtils.subarray(this.window, off, len);
    }
}

