/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.syntax.HTMLTokenMarker;
import com.rapidminer.gui.tools.syntax.JEditTextArea;
import com.rapidminer.operator.Operator;
import java.awt.event.KeyEvent;

public class CommentEditor
extends JEditTextArea
implements ProcessEditor {
    private static final long serialVersionUID = -2661346182983330754L;
    private transient Operator currentOperator;

    public CommentEditor() {
        super(SwingTools.getTextAreaDefaults());
        this.setTokenMarker(new HTMLTokenMarker());
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
        if (this.currentOperator != null) {
            String description = this.currentOperator.getUserDescription();
            if (description != null) {
                String text = SwingTools.text2SimpleHtml(description);
                this.setText(text);
            } else {
                this.setText(null);
            }
        } else {
            this.setText(null);
        }
    }

    public void processChanged(Operator operator) {
    }

    public void validateProcess() throws Exception {
        this.saveComment();
    }

    public void saveComment() {
        String newExp;
        String oldExp = RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getXML("", true);
        if (this.currentOperator != null) {
            this.currentOperator.setUserDescription(SwingTools.html2RapidMinerText(this.getText()));
        }
        if (!(newExp = RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getXML("", true)).equals(oldExp)) {
            RapidMinerGUI.getMainFrame().processChanged();
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        super.processKeyEvent(evt);
        switch (evt.getID()) {
            case 402: {
                this.saveComment();
            }
        }
    }
}

