/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.AssociationRules;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.learner.associations.PowerSet;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationRuleGenerator
extends Operator {
    public static final String PARAMETER_CRITERION = "criterion";
    public static final String PARAMETER_MIN_CONFIDENCE = "min_confidence";
    public static final String PARAMETER_MIN_CRITERION_VALUE = "min_criterion_value";
    public static final String PARAMETER_GAIN_THETA = "gain_theta";
    public static final String PARAMETER_LAPLACE_K = "laplace_k";
    public static final String[] CRITERIA = new String[]{"confidence", "lift", "conviction", "ps", "gain", "laplace"};
    public static final int CONFIDENCE = 0;
    public static final int LIFT = 1;
    public static final int CONVICTION = 2;
    public static final int PS = 3;
    public static final int GAIN = 4;
    public static final int LAPLACE = 5;

    public AssociationRuleGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        double minValue = this.getParameterAsDouble(PARAMETER_MIN_CONFIDENCE);
        if (this.getParameterAsInt(PARAMETER_CRITERION) != 0) {
            minValue = this.getParameterAsDouble(PARAMETER_MIN_CRITERION_VALUE);
        }
        double theta = this.getParameterAsDouble(PARAMETER_GAIN_THETA);
        double laplaceK = this.getParameterAsDouble(PARAMETER_LAPLACE_K);
        FrequentItemSets sets = this.getInput(FrequentItemSets.class);
        AssociationRules rules = new AssociationRules();
        HashMap<Collection<Item>, Integer> setFrequencyMap = new HashMap<Collection<Item>, Integer>();
        int numberOfTransactions = sets.getNumberOfTransactions();
        sets.sortSets();
        for (FrequentItemSet set : sets) {
            setFrequencyMap.put(set.getItems(), set.getFrequency());
            if (set.getItems().size() <= 1) continue;
            PowerSet<Item> powerSet = new PowerSet<Item>(set.getItems());
            for (Collection<Item> collection : powerSet) {
                int conclusionFrequency;
                int preconditionFrequency;
                if (collection.size() <= 0 || collection.size() >= set.getItems().size()) continue;
                Collection<Item> conclusion = powerSet.getComplement(collection);
                int totalFrequency = set.getFrequency();
                double value = this.getCriterionValue(totalFrequency, preconditionFrequency = ((Integer)setFrequencyMap.get(collection)).intValue(), conclusionFrequency = ((Integer)setFrequencyMap.get(conclusion)).intValue(), numberOfTransactions, theta, laplaceK);
                if (!(value >= minValue)) continue;
                AssociationRule rule = new AssociationRule(collection, conclusion, this.getSupport(totalFrequency, numberOfTransactions));
                rule.setConfidence(this.getConfidence(totalFrequency, preconditionFrequency));
                rule.setLift(this.getLift(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions));
                rule.setConviction(this.getConviction(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions));
                rule.setPs(this.getPs(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions));
                rule.setGain(this.getGain(theta, totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions));
                rule.setLaplace(this.getLaPlace(laplaceK, totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions));
                rules.addItemRule(rule);
            }
        }
        return new IOObject[]{rules};
    }

    private double getCriterionValue(int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions, double theta, double laplaceK) throws OperatorException {
        int criterion = this.getParameterAsInt(PARAMETER_CRITERION);
        switch (criterion) {
            case 1: {
                return this.getLift(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions);
            }
            case 2: {
                return this.getConviction(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions);
            }
            case 3: {
                return this.getPs(totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions);
            }
            case 4: {
                return this.getGain(theta, totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions);
            }
            case 5: {
                return this.getLaPlace(laplaceK, totalFrequency, preconditionFrequency, conclusionFrequency, numberOfTransactions);
            }
        }
        return this.getConfidence(totalFrequency, preconditionFrequency);
    }

    private double getGain(double theta, int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions) {
        return this.getSupport(totalFrequency, numberOfTransactions) - theta * this.getSupport(preconditionFrequency, numberOfTransactions);
    }

    private double getLift(int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions) {
        return (double)totalFrequency * (double)numberOfTransactions / ((double)preconditionFrequency * (double)conclusionFrequency);
    }

    private double getPs(int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions) {
        return this.getSupport(totalFrequency, numberOfTransactions) - this.getSupport(preconditionFrequency, numberOfTransactions) * this.getSupport(conclusionFrequency, numberOfTransactions);
    }

    private double getLaPlace(double k, int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions) {
        return (this.getSupport(totalFrequency, numberOfTransactions) + 1.0) / (this.getSupport(preconditionFrequency, numberOfTransactions) + k);
    }

    private double getConviction(int totalFrequency, int preconditionFrequency, int conclusionFrequency, int numberOfTransactions) {
        double numerator = preconditionFrequency * (numberOfTransactions - conclusionFrequency);
        double denumerator = numberOfTransactions * (preconditionFrequency - totalFrequency);
        return numerator / denumerator;
    }

    private double getConfidence(int totalFrequency, int preconditionFrequency) {
        return (double)totalFrequency / (double)preconditionFrequency;
    }

    private double getSupport(int frequency, int completeSize) {
        return (double)frequency / (double)completeSize;
    }

    public InputDescription getInputDescription(Class cls) {
        if (FrequentItemSets.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{FrequentItemSets.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{AssociationRules.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_CRITERION, "The criterion which is used for the selection of rules", CRITERIA, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_CONFIDENCE, "The minimum confidence of the rules", 0.0, 1.0, 0.8);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_CRITERION, true, 0));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_CRITERION_VALUE, "The minimum value of the rules for the selected criterion", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.8);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_CRITERION, true, 1, 2, 3, 4, 5));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_GAIN_THETA, "The Parameter Theta in Gain calculation", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LAPLACE_K, "The Parameter k in LaPlace function calculation", 1.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

