/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.learner.meta.TransformedRegressionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedRegression
extends OperatorChain {
    public static final String PARAMETER_TRANSFORMATION_METHOD = "transformation_method";
    public static final String PARAMETER_Z_SCALE = "z_scale";
    public static final String PARAMETER_INTERPOLATE_RANK = "interpolate_rank";

    public TransformedRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        int method = this.getParameterAsInt(PARAMETER_TRANSFORMATION_METHOD);
        double[] rank = null;
        double mean = 0.0;
        double stddev = 1.0;
        Attribute label = inputSet.getAttributes().getLabel();
        inputSet.recalculateAttributeStatistics(label);
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("temp_transformed_regression_label", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        Iterator r = eSet.iterator();
        switch (method) {
            case 0: {
                Example e;
                double offset = 1.0 - inputSet.getStatistics(label, "minimum");
                rank = new double[]{offset};
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.log(offset + e.getValue(label)));
                }
                break;
            }
            case 1: {
                Example e;
                while (r.hasNext()) {
                    e = (Example)r.next();
                    double value = e.getValue(label);
                    if (value >= 1.0) {
                        value = 0.99999999999;
                    }
                    if (value <= 0.0) {
                        value = 1.0E-11;
                    }
                    e.setValue(tempLabel, Math.log(value / (1.0 - value)));
                }
                break;
            }
            case 2: {
                Example e;
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.exp(e.getValue(label)));
                }
                break;
            }
            case 3: {
                double[] dummy = new double[eSet.size()];
                int i = 0;
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    dummy[i] = e.getValue(label);
                    ++i;
                }
                Arrays.sort(dummy);
                i = 0;
                int j = 0;
                while (j < dummy.length) {
                    if (dummy[i] != dummy[j]) {
                        dummy[++i] = dummy[j];
                    }
                    ++j;
                }
                rank = new double[i + 1];
                j = 0;
                while (j < i + 1) {
                    rank[j] = dummy[j];
                    ++j;
                }
                for (Example e : eSet) {
                    e.setValue(tempLabel, Arrays.binarySearch(rank, e.getValue(label)));
                }
                break;
            }
            case 4: {
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    e.setValue(tempLabel, e.getValue(label));
                }
                break;
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_Z_SCALE)) {
            eSet.recalculateAttributeStatistics(tempLabel);
            mean = eSet.getStatistics(tempLabel, "average");
            stddev = eSet.getStatistics(tempLabel, "variance");
            if (stddev <= 0.0) {
                stddev = 1.0;
            }
            for (Example e : eSet) {
                e.setValue(tempLabel, (e.getValue(tempLabel) - mean) / stddev);
            }
        }
        eSet.getAttributes().remove(label);
        eSet.getAttributes().addRegular(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        IOContainer input = new IOContainer(eSet);
        input = this.getOperator(0).apply(input);
        Model model = input.remove(Model.class);
        TransformedRegressionModel resultModel = new TransformedRegressionModel(inputSet, method, rank, model, this.getParameterAsBoolean(PARAMETER_Z_SCALE), mean, stddev, this.getParameterAsBoolean(PARAMETER_INTERPOLATE_RANK));
        AttributeWeights weights = null;
        try {
            weights = input.remove(AttributeWeights.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        if (weights == null) {
            return new IOObject[]{resultModel};
        }
        return new IOObject[]{resultModel, weights};
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_TRANSFORMATION_METHOD, "Type of transformation to use on the labels (log, exp, transform to mean 0 and variance 1, rank, or none).", TransformedRegressionModel.METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_Z_SCALE, "Scale transformed values to mean 0 and standard deviation 1?", false);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INTERPOLATE_RANK, "Interpolate prediction if predicted rank is not an integer?", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

