/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.AbstractSplitChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteSplitChain
extends AbstractSplitChain {
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final String PARAMETER_NUMBER_TRAINING_EXAMPLES = "number_training_examples";
    private static final String PARAMETER_NUMBER_TEST_EXAMPLES = "number_test_examples";

    public AbsoluteSplitChain(OperatorDescription description) {
        super(description);
    }

    @Override
    protected SplittedExampleSet createSplittedExampleSet(ExampleSet inputSet) throws OperatorException {
        int size = -1;
        if (this.getParameterAsInt(PARAMETER_NUMBER_TEST_EXAMPLES) == -1) {
            if (this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES) == -1) {
                throw new UserError((Operator)this, 208, PARAMETER_NUMBER_TEST_EXAMPLES, PARAMETER_NUMBER_TRAINING_EXAMPLES);
            }
            size = this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES);
        } else {
            if (this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES) != -1) {
                throw new UserError((Operator)this, 209, PARAMETER_NUMBER_TEST_EXAMPLES, PARAMETER_NUMBER_TRAINING_EXAMPLES);
            }
            size = inputSet.size() - this.getParameterAsInt(PARAMETER_NUMBER_TEST_EXAMPLES);
        }
        return new SplittedExampleSet(inputSet, (double)size / (double)inputSet.size(), this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_TRAINING_EXAMPLES, "Absolute size of the training set. -1 equal to not defined", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_TEST_EXAMPLES, "Absolute size of the test set. -1 equal to not defined", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

