/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.AbstractExampleSetEvaluator;
import com.rapidminer.operator.performance.MDLCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeCounter
extends AbstractExampleSetEvaluator {
    public static final String PARAMETER_OPTIMIZATION_DIRECTION = "optimization_direction";
    private double lastCount = Double.NaN;

    public AttributeCounter(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("attributes", "The currently selected number of attributes."){

            public double getDoubleValue() {
                return AttributeCounter.this.lastCount;
            }
        });
    }

    private PerformanceVector count(ExampleSet exampleSet, PerformanceVector performanceCriteria) throws OperatorException {
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        }
        MDLCriterion mdlCriterion = new MDLCriterion(this.getParameterAsInt(PARAMETER_OPTIMIZATION_DIRECTION));
        mdlCriterion.startCounting(exampleSet, true);
        this.lastCount = mdlCriterion.getAverage();
        performanceCriteria.addCriterion(mdlCriterion);
        return performanceCriteria;
    }

    @Override
    public PerformanceVector evaluate(ExampleSet exampleSet) throws OperatorException {
        PerformanceVector inputPerformance = null;
        try {
            inputPerformance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        PerformanceVector performance = this.count(exampleSet, inputPerformance);
        return performance;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_OPTIMIZATION_DIRECTION, "Indicates if the fitness should be maximal for the maximal or for the minimal number of features.", MDLCriterion.DIRECTIONS, 0));
        return types;
    }
}

