/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAttributeFilter
extends AbstractAttributeFilterCondition {
    private String nameRegex;

    @Override
    public void init(Operator operator) throws UserError {
        this.nameRegex = operator.getParameterAsString("parameter_string");
        if (this.nameRegex == null || this.nameRegex.length() == 0) {
            throw new UserError(operator, 904, "The condition for attribute names needs a parameter string.");
        }
    }

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        if (!attribute.getName().matches(this.nameRegex)) {
            return AttributeFilterCondition.ScanResult.REMOVE;
        }
        return AttributeFilterCondition.ScanResult.KEEP;
    }

    @Override
    public List<ParameterType> getParameterTypes(Operator operator) {
        return super.getParameterTypes(operator);
    }
}

