/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class RegularizedCepstrumEstimator {
    public static final double DEFAULT_LAMBDA = 5.0E-4;
    public static final int REGULARIZED_CEPSTRUM_WITH_PRE_BARK_WARPING = 1;
    public static final int REGULARIZED_CEPSTRUM_WITH_POST_MEL_WARPING = 2;

    protected static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, boolean isPreWarping, double[] weights, double lambda) {
        int i;
        assert (linearAmps.length == freqsInHz.length);
        double[] a = MathUtils.amp2db(linearAmps);
        int L = linearAmps.length;
        int p = cepsOrder;
        double[][] M = new double[L][p + 1];
        double denum = 1.0;
        if (isPreWarping) {
            denum = 2.0 * SignalProcUtils.freq2barkNew(0.5 * (double)samplingRateInHz);
        }
        for (i = 0; i < L; ++i) {
            int j;
            double f;
            M[i][0] = 1.0;
            if (isPreWarping) {
                f = SignalProcUtils.freq2barkNew(freqsInHz[i]) / denum;
                for (j = 1; j < p + 1; ++j) {
                    M[i][j] = 2.0 * Math.cos(Math.PI * 2 * f * (double)j);
                }
                continue;
            }
            f = SignalProcUtils.hz2radian(freqsInHz[i], samplingRateInHz);
            for (j = 1; j < p + 1; ++j) {
                M[i][j] = 2.0 * Math.cos(f * (double)j);
            }
        }
        double[] diagR = new double[p + 1];
        double tmp = 78.95683520871486;
        for (i = 0; i < p + 1; ++i) {
            diagR[i] = tmp * (double)i * (double)i;
        }
        double[][] R = MathUtils.toDiagonalMatrix(diagR);
        double[] cepsDouble = null;
        if (weights != null) {
            double[][] W = MathUtils.toDiagonalMatrix(weights);
            double[][] MTrans = MathUtils.transpoze(M);
            double[][] MTransW = MathUtils.matrixProduct(MTrans, W);
            double[][] MTransWM = MathUtils.matrixProduct(MTransW, M);
            double[][] lambdaR = MathUtils.multiply(lambda, R);
            double[] MTransWa = MathUtils.matrixProduct(MTransW, a);
            double[][] inverted = MathUtils.inverse(MathUtils.add(MTransWM, lambdaR));
            cepsDouble = MathUtils.matrixProduct(inverted, MTransWa);
        } else {
            double[][] MTrans = MathUtils.transpoze(M);
            double[][] MTransM = MathUtils.matrixProduct(MTrans, M);
            double[][] lambdaR = MathUtils.multiply(lambda, R);
            double[] MTransa = MathUtils.matrixProduct(MTrans, a);
            double[][] inverted = MathUtils.inverse(MathUtils.add(MTransM, lambdaR));
            cepsDouble = MathUtils.matrixProduct(inverted, MTransa);
        }
        float[] ceps = ArrayUtils.copyDouble2Float(cepsDouble);
        return ceps;
    }

    protected static double[][] precomputeM(double[] freqsInHz, int samplingRateInHz, int cepsOrder, boolean isPreWarping) {
        int L = freqsInHz.length;
        int p = cepsOrder;
        double[][] M = new double[L][p + 1];
        double denum = 1.0;
        if (isPreWarping) {
            denum = 2.0 * SignalProcUtils.freq2barkNew(0.5 * (double)samplingRateInHz);
        }
        for (int i = 0; i < L; ++i) {
            int j;
            double f;
            M[i][0] = 1.0;
            if (isPreWarping) {
                f = SignalProcUtils.freq2barkNew(freqsInHz[i]) / denum;
                for (j = 1; j < p + 1; ++j) {
                    M[i][j] = 2.0 * Math.cos(Math.PI * 2 * f * (double)j);
                }
                continue;
            }
            f = SignalProcUtils.hz2radian(freqsInHz[i], samplingRateInHz);
            for (j = 1; j < p + 1; ++j) {
                M[i][j] = 2.0 * Math.cos(f * (double)j);
            }
        }
        return M;
    }

    public static double[][] precomputeMTransW(double[][] M, double[] weights) {
        double[][] MTransW = null;
        if (weights != null) {
            double[][] W = MathUtils.toDiagonalMatrix(weights);
            double[][] MTrans = MathUtils.transpoze(M);
            MTransW = MathUtils.matrixProduct(MTrans, W);
        } else {
            MTransW = MathUtils.transpoze(M);
        }
        return MTransW;
    }

    public static double[][] precomputeMTransWM(double[][] MTransW, double[][] M) {
        double[][] MTransWM = MathUtils.matrixProduct(MTransW, M);
        return MTransWM;
    }

    public static double[][] precomputeLambdaR(double lambda, int cepsOrder) {
        int p = cepsOrder;
        double[] diagR = new double[p + 1];
        double tmp = 78.95683520871486;
        for (int i = 0; i < p + 1; ++i) {
            diagR[i] = tmp * (double)i * (double)i;
        }
        double[][] R = MathUtils.toDiagonalMatrix(diagR);
        double[][] lambdaR = MathUtils.multiply(lambda, R);
        return lambdaR;
    }

    public static double[][] precomputeInverted(double[][] MTransWM, double[][] lambdaR) {
        double[][] inverted = MathUtils.inverse(MathUtils.add(MTransWM, lambdaR));
        return inverted;
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[][] MTransW, double[][] inverted) {
        double[] logAmps = MathUtils.log10(linearAmps);
        double[] a = MathUtils.multiply(logAmps, 20.0);
        double[] cepsDouble = null;
        double[] MTransWa = MathUtils.matrixProduct(MTransW, a);
        cepsDouble = MathUtils.matrixProduct(inverted, MTransWa);
        float[] ceps = ArrayUtils.copyDouble2Float(cepsDouble);
        return ceps;
    }

    protected static double[] cepstrum2logAmpHalfSpectrum(float[] ceps, int fftSize, int samplingRateInHz, boolean isPreWarping) {
        int maxFreq = SignalProcUtils.halfSpectrumSize(fftSize);
        double[] halfAbsSpectrum = new double[maxFreq];
        int p = ceps.length - 1;
        double denum = samplingRateInHz;
        if (isPreWarping) {
            denum = 2.0 * SignalProcUtils.freq2barkNew(0.5 * (double)samplingRateInHz);
        }
        for (int k = 0; k < maxFreq; ++k) {
            int i;
            double f;
            halfAbsSpectrum[k] = ceps[0];
            if (isPreWarping) {
                f = SignalProcUtils.freq2barkNew((double)k / ((double)maxFreq - 1.0) * 0.5 * (double)samplingRateInHz) / denum;
                for (i = 1; i <= p; ++i) {
                    int n = k;
                    halfAbsSpectrum[n] = halfAbsSpectrum[n] + 2.0 * (double)ceps[i] * Math.cos(Math.PI * 2 * f * (double)i);
                }
                continue;
            }
            f = SignalProcUtils.index2freq(k, samplingRateInHz, maxFreq - 1);
            f = SignalProcUtils.hz2radian(f, samplingRateInHz);
            for (i = 1; i <= p; ++i) {
                int n = k;
                halfAbsSpectrum[n] = halfAbsSpectrum[n] + 2.0 * (double)ceps[i] * Math.cos(f * (double)i);
            }
        }
        return halfAbsSpectrum;
    }
}

