/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

public class OperatorCreationException
extends Exception {
    private static final long serialVersionUID = 805882946295847566L;
    public static final int INSTANTIATION_ERROR = 0;
    public static final int ILLEGAL_ACCESS_ERROR = 1;
    public static final int NO_CONSTRUCTOR_ERROR = 2;
    public static final int CONSTRUCTION_ERROR = 3;
    public static final int NO_DESCRIPTION_ERROR = 4;
    public static final int NO_UNIQUE_DESCRIPTION_ERROR = 5;

    public OperatorCreationException(int code, String className, Throwable cause) {
        super(OperatorCreationException.createMessage(code, className, cause));
    }

    private static String createMessage(int code, String className, Throwable cause) {
        switch (code) {
            case 0: {
                return "Cannot instantiate '" + className + "': " + cause.getMessage();
            }
            case 1: {
                return "Cannot access '" + className + "':" + cause.getMessage();
            }
            case 2: {
                return "No public one-argument constructor for operator descriptions: '" + className + "': " + cause.getMessage();
            }
            case 3: {
                return "Operator cannot be constructed: '" + className + "': " + cause.getCause().getMessage();
            }
            case 4: {
                return "No operator description object given for '" + className + (cause != null ? "': " + cause.getMessage() : "'");
            }
            case 5: {
                return "No unique operator description object available for class '" + className + "': " + cause.getMessage();
            }
        }
        return "Error during operator creation of '" + className + "': " + cause.getMessage();
    }
}

