/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.io.BytewiseExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DasyLabDataReader
extends BytewiseExampleSource {
    public static final String PARAMETER_TIMESTAMP = "timestamp";
    public static final String[] PARAMETER_TIMESTAMP_OPTIONS = new String[]{"none", "relative", "absolute"};
    public static final int TIMESTAMP_NONE = 0;
    public static final int TIMESTAMP_RELATIVE = 1;
    public static final int TIMESTAMP_ABSOLUTE = 2;
    private static final String NOT_YET_IMPLEMENTED_ERROR_MESSAGE = "feature not yet implemented, ";
    private static final String FILE_HEADER_STRING = "DTDF";
    private static final byte STRING_TERMINATOR_BYTE = 0;
    private static final int FILE_TYPE_UNIVERSAL_FORMAT_1 = 1;

    public DasyLabDataReader(OperatorDescription description) {
        super(description);
    }

    @Override
    protected String getFileSuffix() {
        return "ddf";
    }

    @Override
    protected ExampleSet readStream(InputStream inputStream, DataRowFactory dataRowFactory) throws IOException, UndefinedParameterError {
        boolean separateFile;
        int timestampMode = this.getParameterAsInt(PARAMETER_TIMESTAMP);
        byte[] buffer = new byte[500];
        int readBytes = -1;
        this.read(inputStream, buffer, 5);
        if (!this.extractString(buffer, 0, 4).equals(FILE_HEADER_STRING)) {
            throw new IOException("Wrong file format");
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            byte readByte;
            if ((readByte = (byte)(0xFF & inputStream.read())) == -1) {
                throw new IOException("Wrong file format");
            }
            if (readByte == 0) break;
            stringBuffer.append((char)readByte);
        }
        this.read(inputStream, buffer, 3);
        if (!this.extractString(buffer, 1, 2).equals("IN")) {
            throw new IOException("Wrong file format");
        }
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        int fileType = this.extract2ByteInt(buffer, 0, true);
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        boolean bl = separateFile = this.extract2ByteInt(buffer, 0, true) == 1;
        if (separateFile) {
            throw new IOException("feature not yet implemented, separate files not allowed");
        }
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 8);
        this.read(inputStream, buffer, 4);
        if (fileType != 1) {
            throw new IOException("feature not yet implemented, file types other than universal format 1 not supported");
        }
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 2);
        int numberOfChannels = this.extract2ByteInt(buffer, 0, true);
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 32);
        Channel[] channels = new Channel[numberOfChannels];
        int i = 0;
        while (i < numberOfChannels) {
            Channel channel = new Channel();
            this.read(inputStream, buffer, 2);
            this.read(inputStream, buffer, 2);
            this.read(inputStream, buffer, 2);
            this.read(inputStream, buffer, 8);
            this.read(inputStream, buffer, 2);
            channel.type = this.extract2ByteInt(buffer, 0, true);
            if (channel.type == 20 || channel.type == 21) {
                throw new IOException("feature not yet implemented, histogram data not supported");
            }
            this.read(inputStream, buffer, 2);
            this.read(inputStream, buffer, 16);
            readBytes = this.read(inputStream, buffer, '\u0000');
            readBytes = this.read(inputStream, buffer, '\u0000');
            if (readBytes != -1) {
                channel.name = this.extractString(buffer, 0, readBytes);
            }
            channels[i] = channel;
            ++i;
        }
        this.read(inputStream, buffer, 4);
        if (!this.extractString(buffer, 0, 4).equals("DATA")) {
            throw new IOException("Wrong file format");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numberOfChannels);
        switch (timestampMode) {
            case 0: {
                break;
            }
            case 1: {
                attributes.add(AttributeFactory.createAttribute(PARAMETER_TIMESTAMP, 4));
                break;
            }
            case 2: {
                attributes.add(AttributeFactory.createAttribute(PARAMETER_TIMESTAMP, 9));
            }
        }
        int i2 = 0;
        while (i2 < numberOfChannels) {
            Attribute attribute = AttributeFactory.createAttribute(channels[i2].name, 4);
            attributes.add(attribute);
            ++i2;
        }
        this.read(inputStream, buffer, 2);
        this.read(inputStream, buffer, 4);
        double startTime = (long)this.extractInt(buffer, 0, true) * 1000L;
        this.read(inputStream, buffer, 8);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        HashMap<Double, Double[]> valuesMap = new HashMap<Double, Double[]>();
        HashMap<Double, Integer> counterMap = new HashMap<Double, Integer>();
        boolean eof = false;
        block13: while (!eof) {
            readBytes = inputStream.read(buffer, 0, 20);
            if (readBytes != 20) {
                eof = true;
                break;
            }
            int channelNr = this.extract2ByteInt(buffer, 0, true);
            double time = this.extractDouble(buffer, 2, true);
            double delay = this.extractDouble(buffer, 10, true);
            int blockSize = this.extract2ByteInt(buffer, 18, true);
            int i3 = 0;
            while (i3 < blockSize) {
                readBytes = inputStream.read(buffer, 20, 4);
                if (readBytes != 4) {
                    eof = true;
                    continue block13;
                }
                double value = this.extractFloat(buffer, 20, true);
                Double[] values = null;
                if (!valuesMap.containsKey(time)) {
                    counterMap.put(time, 1);
                    values = new Double[timestampMode == 0 ? numberOfChannels : numberOfChannels + 1];
                    int j = 1;
                    while (j < values.length) {
                        values[j] = Double.NaN;
                        ++j;
                    }
                    valuesMap.put(time, values);
                } else {
                    Integer counter = (Integer)counterMap.get(time) + 1;
                    counterMap.put(time, counter);
                    values = (Double[])valuesMap.get(time);
                }
                if (values != null) {
                    switch (timestampMode) {
                        case 0: {
                            values[channelNr] = value;
                            break;
                        }
                        case 1: {
                            values[0] = (long)(time * 1000.0);
                            values[channelNr + 1] = value;
                            break;
                        }
                        case 2: {
                            values[0] = (long)startTime + (long)(time * 1000.0);
                            values[channelNr + 1] = value;
                        }
                    }
                }
                if ((Integer)counterMap.get(time) == numberOfChannels) {
                    table.addDataRow(dataRowFactory.create((Double[])valuesMap.get(time), attributes.toArray(new Attribute[attributes.size()])));
                    counterMap.remove(time);
                    valuesMap.remove(time);
                }
                time += delay;
                ++i3;
            }
        }
        inputStream.close();
        ExampleSet exampleSet = table.createExampleSet();
        if (timestampMode != 0) {
            exampleSet.getAttributes().setId(attributes.get(0));
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_TIMESTAMP, "Specifies whether to include an absolute timestamp, a timestamp relative to the beginning of the file (in seconds) or no timestamp at all.", PARAMETER_TIMESTAMP_OPTIONS, 2));
        return types;
    }

    private class Channel {
        private static final int HISTOGRAM = 20;
        private static final int HISTOGRAM_WITH_TIME_INFORMATION = 21;
        private int type;
        private String name;

        private Channel() {
        }
    }
}

