/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Real2Integer
extends AbstractDataProcessing {
    public static final String PARAMETER_ROUND = "round";

    public Real2Integer(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        boolean round = this.getParameterAsBoolean(PARAMETER_ROUND);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> a = exampleSet.getAttributes().iterator();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3)) continue;
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName(), 3);
            newAttributes.add(newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            for (Example example : exampleSet) {
                double originalValue = example.getValue(attribute);
                long newValue = round ? Math.round(originalValue) : (long)originalValue;
                example.setValue(newAttribute, newValue);
            }
            a.remove();
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_ROUND, "Indicates if the values should be rounded instead of cutted.", false));
        return types;
    }
}

