/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetIntersect
extends Operator {
    public ExampleSetIntersect(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet secondSet = this.getInput(ExampleSet.class);
        ExampleSet firstSet = this.getInput(ExampleSet.class);
        secondSet.remapIds();
        firstSet.remapIds();
        Attribute firstId = firstSet.getAttributes().getId();
        Attribute secondId = secondSet.getAttributes().getId();
        if (firstId == null || secondId == null) {
            throw new UserError(this, 129);
        }
        if (firstId.getValueType() != secondId.getValueType()) {
            throw new UserError((Operator)this, 120, secondId.getName(), Ontology.VALUE_TYPE_NAMES[secondId.getValueType()], Ontology.VALUE_TYPE_NAMES[firstId.getValueType()]);
        }
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        for (Example firstExample : firstSet) {
            double id = firstExample.getValue(firstId);
            Example secondExample = null;
            secondExample = firstId.isNominal() ? secondSet.getExampleFromId(secondId.getMapping().getIndex(firstId.getMapping().mapIndex((int)id))) : secondSet.getExampleFromId(id);
            if (secondExample != null) {
                indices.add(i);
            }
            ++i;
        }
        int[] indexArray = new int[indices.size()];
        int i2 = 0;
        while (i2 < indices.size()) {
            indexArray[i2] = (Integer)indices.get(i2);
            ++i2;
        }
        MappedExampleSet intersectionSet = new MappedExampleSet(firstSet, indexArray);
        return new IOObject[]{intersectionSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        return types;
    }
}

