/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Norm;
import Jampack.Schur;
import Jampack.Times;
import Jampack.Z;
import Jampack.Zdiagmat;
import Jampack.Zmat;
import Jampack.Zutmat;

public class Eig {
    public Zmat X;
    public Zdiagmat D;

    public Eig(Zmat A) throws JampackException {
        A.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Matrix not square.");
        }
        int n = A.nr;
        Schur S = new Schur(A);
        Zutmat T = S.T;
        this.D = new Zdiagmat(T);
        double norm = Norm.fro(A);
        this.X = new Zmat(n, n);
        for (int k = n - 1; k >= 0; --k) {
            int i;
            Z d = T.get0(k, k);
            this.X.re[k][k] = 1.0;
            this.X.im[k][k] = 0.0;
            for (i = k - 1; i >= 0; --i) {
                this.X.re[i][k] = -T.re[i][k];
                this.X.im[i][k] = -T.im[i][k];
                for (int j = i + 1; j < k; ++j) {
                    this.X.re[i][k] = this.X.re[i][k] - T.re[i][j] * this.X.re[j][k] + T.im[i][j] * this.X.im[j][k];
                    this.X.im[i][k] = this.X.im[i][k] - T.re[i][j] * this.X.im[j][k] - T.im[i][j] * this.X.re[j][k];
                }
                Z z = T.get0(i, i);
                z.Minus(z, d);
                if (z.re == 0.0 && z.im == 0.0) {
                    z.re = 1.0E-16 * norm;
                }
                z.Div(this.X.get0(i, k), z);
                this.X.put0(i, k, z);
            }
            double scale = 1.0 / Norm.fro(this.X, this.X.bx, this.X.rx, this.X.bx + k, this.X.bx + k);
            for (i = 0; i < this.X.nr; ++i) {
                this.X.re[i][k] = scale * this.X.re[i][k];
                this.X.im[i][k] = scale * this.X.im[i][k];
            }
        }
        this.X = Times.o(S.U, this.X);
    }
}

