/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.IOException;
import marytts.cart.CART;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.io.HTSCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSModel;
import marytts.htsengine.PhoneTranslator;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class CartTreeSet {
    private Logger logger = MaryUtils.getLogger("CartTreeSet");
    private CART[] durTree;
    private CART[] lf0Tree;
    private CART[] mgcTree;
    private CART[] strTree;
    private CART[] magTree;
    private int numStates;
    private int lf0Stream;
    private int mcepVsize;
    private int strVsize;
    private int magVsize;
    HTSCARTReader htsReader = new HTSCARTReader();

    public int getNumStates() {
        return this.numStates;
    }

    public void setNumStates(int val) {
        this.numStates = val;
    }

    public int getLf0Stream() {
        return this.lf0Stream;
    }

    public int getMcepVsize() {
        return this.mcepVsize;
    }

    public int getStrVsize() {
        return this.strVsize;
    }

    public int getMagVsize() {
        return this.magVsize;
    }

    public void loadTreeSet(HMMData htsData, FeatureDefinition featureDef, PhoneTranslator trickyPhones) throws IOException, MaryConfigurationException {
        PhoneTranslator phTranslator = trickyPhones;
        if (htsData.getTreeDurStream() != null) {
            this.logger.debug("Loading duration tree...");
            this.durTree = this.htsReader.load(1, htsData.getTreeDurStream(), htsData.getPdfDurStream(), HMMData.PdfFileFormat.dur, featureDef, phTranslator);
            this.numStates = this.htsReader.getVectorSize();
        }
        if (htsData.getTreeLf0Stream() != null) {
            this.logger.debug("Loading log F0 tree...");
            this.lf0Tree = this.htsReader.load(this.numStates, htsData.getTreeLf0Stream(), htsData.getPdfLf0Stream(), HMMData.PdfFileFormat.lf0, featureDef, phTranslator);
            this.lf0Stream = this.htsReader.getVectorSize();
        }
        if (htsData.getTreeMgcStream() != null) {
            this.logger.debug("Loading mgc tree...");
            this.mgcTree = this.htsReader.load(this.numStates, htsData.getTreeMgcStream(), htsData.getPdfMgcStream(), HMMData.PdfFileFormat.mgc, featureDef, phTranslator);
            this.mcepVsize = this.htsReader.getVectorSize();
        }
        if (htsData.getTreeStrStream() != null) {
            this.logger.debug("Loading str tree...");
            this.strTree = this.htsReader.load(this.numStates, htsData.getTreeStrStream(), htsData.getPdfStrStream(), HMMData.PdfFileFormat.str, featureDef, phTranslator);
            this.strVsize = this.htsReader.getVectorSize();
        }
        if (htsData.getTreeMagStream() != null) {
            this.logger.debug("Loading mag tree...");
            this.magTree = this.htsReader.load(this.numStates, htsData.getTreeMagStream(), htsData.getPdfMagStream(), HMMData.PdfFileFormat.mag, featureDef, phTranslator);
            this.magVsize = this.htsReader.getVectorSize();
        }
    }

    public double searchDurInCartTree(HTSModel m, FeatureVector fv, HMMData htsData, double diffdur) throws Exception {
        return this.searchDurInCartTree(m, fv, htsData, false, false, diffdur);
    }

    public double searchDurInCartTree(HTSModel m, FeatureVector fv, HMMData htsData, boolean firstPh, boolean lastPh, double diffdur) throws Exception {
        double rho = htsData.getRho();
        double durscale = htsData.getDurationScale();
        Node node = this.durTree[0].interpretToNode(fv, 1);
        if (!(node instanceof LeafNode.PdfLeafNode)) {
            throw new Exception("searchDurInCartTree: The node must be a PdfLeafNode");
        }
        double[] meanVector = ((LeafNode.PdfLeafNode)node).getMean();
        double[] varVector = ((LeafNode.PdfLeafNode)node).getVariance();
        double dd = diffdur;
        for (int s = 0; s < this.numStates; ++s) {
            double data = meanVector[s] + rho * varVector[s];
            m.setDur(s, (int)((data *= durscale) + dd + 0.5));
            if (m.getDur(s) < 1) {
                m.setDur(s, 1);
            }
            m.setTotalDur(m.getTotalDur() + m.getDur(s));
            dd += data - (double)m.getDur(s);
        }
        return dd;
    }

    public void searchLf0InCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef, double uvthresh) throws Exception {
        for (int s = 0; s < this.numStates; ++s) {
            Node node = this.lf0Tree[s].interpretToNode(fv, 1);
            if (!(node instanceof LeafNode.PdfLeafNode)) {
                throw new Exception("searchLf0InCartTree: The node must be a PdfLeafNode");
            }
            m.setLf0Mean(s, ((LeafNode.PdfLeafNode)node).getMean());
            m.setLf0Variance(s, ((LeafNode.PdfLeafNode)node).getVariance());
            if (((LeafNode.PdfLeafNode)node).getVoicedWeight() > uvthresh) {
                m.setVoiced(s, true);
                continue;
            }
            m.setVoiced(s, false);
        }
    }

    public void searchMgcInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) throws Exception {
        for (int s = 0; s < this.numStates; ++s) {
            Node node = this.mgcTree[s].interpretToNode(fv, 1);
            if (!(node instanceof LeafNode.PdfLeafNode)) {
                throw new Exception("searchMgcInCartTree: The node must be a PdfLeafNode");
            }
            m.setMcepMean(s, ((LeafNode.PdfLeafNode)node).getMean());
            m.setMcepVariance(s, ((LeafNode.PdfLeafNode)node).getVariance());
        }
    }

    public void searchStrInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) throws Exception {
        for (int s = 0; s < this.numStates; ++s) {
            Node node = this.strTree[s].interpretToNode(fv, 1);
            if (!(node instanceof LeafNode.PdfLeafNode)) {
                throw new Exception("searchStrInCartTree: The node must be a PdfLeafNode");
            }
            m.setStrMean(s, ((LeafNode.PdfLeafNode)node).getMean());
            m.setStrVariance(s, ((LeafNode.PdfLeafNode)node).getVariance());
        }
    }

    public void searchMagInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) throws Exception {
        for (int s = 0; s < this.numStates; ++s) {
            Node node = this.magTree[s].interpretToNode(fv, 1);
            if (!(node instanceof LeafNode.PdfLeafNode)) {
                throw new Exception("searchMagInCartTree: The node must be a PdfLeafNode");
            }
            m.setMagMean(s, ((LeafNode.PdfLeafNode)node).getMean());
            m.setMagVariance(s, ((LeafNode.PdfLeafNode)node).getVariance());
        }
    }
}

