/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.process.EnergyNormaliser;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.MixerDoubleDataSource;
import marytts.util.data.NoiseDoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;
import marytts.util.data.SilenceDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class AudioFileMixer {
    public static void mixTwoFiles(String inputFile1, double mixAmount1, String inputFile2, double mixAmount2, String outputFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio1 = AudioSystem.getAudioInputStream(new File(inputFile1));
        int samplingRate1 = (int)inputAudio1.getFormat().getSampleRate();
        AudioDoubleDataSource signal1 = new AudioDoubleDataSource(inputAudio1);
        double[] x1 = signal1.getAllData();
        AudioInputStream inputAudio2 = AudioSystem.getAudioInputStream(new File(inputFile2));
        int samplingRate2 = (int)inputAudio1.getFormat().getSampleRate();
        AudioDoubleDataSource signal2 = new AudioDoubleDataSource(inputAudio2);
        double[] x2 = signal2.getAllData();
        if (samplingRate1 != samplingRate2) {
            System.out.println("Error! Sampling rates must be identical for mixing...");
        } else {
            double[] x3 = new double[Math.max(x1.length, x2.length)];
            if (x1.length > x2.length) {
                int i;
                for (i = 0; i < x2.length; ++i) {
                    x3[i] = mixAmount1 * x1[i] + mixAmount2 * x2[i];
                }
                for (i = x2.length; i < x3.length; ++i) {
                    x3[i] = mixAmount1 * x1[i];
                }
            } else {
                int i;
                for (i = 0; i < x1.length; ++i) {
                    x3[i] = mixAmount1 * x1[i] + mixAmount2 * x2[i];
                }
                for (i = x1.length; i < x3.length; ++i) {
                    x3[i] = mixAmount2 * x2[i];
                }
            }
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(x3), inputAudio1.getFormat());
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outputFile));
        }
    }

    public static void main(String[] args) throws Exception {
        String prop;
        ArrayList<BaseDoubleDataSource> audio = new ArrayList<BaseDoubleDataSource>();
        double[] audioData = null;
        ArrayList<BufferedDoubleDataSource> referenceAudio = new ArrayList<BufferedDoubleDataSource>();
        ArrayList<String> noiseSpecs = new ArrayList<String>();
        double maxDuration = 0.0;
        int i = 0;
        AudioFormat format = args.length > 0 ? AudioSystem.getAudioInputStream(new File(args[0])).getFormat() : new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
        while (!(prop = System.getProperty("audio." + ++i, "")).equals("")) {
            double[] signal;
            double duration;
            AudioInputStream ais;
            BaseDoubleDataSource dds = null;
            if (prop.startsWith("noise:")) {
                noiseSpecs.add(prop);
                continue;
            }
            String[] info = prop.split(":");
            String filename = info[info.length - 1];
            double start = 0.0;
            if (info.length > 1) {
                start = Double.valueOf(info[0]);
            }
            if (!format.equals((ais = AudioSystem.getAudioInputStream(new File(filename))).getFormat())) {
                ais = AudioSystem.getAudioInputStream(format, ais);
            }
            if ((duration = (double)((float)(signal = new AudioDoubleDataSource(ais).getAllData()).length / format.getSampleRate())) > maxDuration) {
                maxDuration = duration;
            }
            referenceAudio.add(new BufferedDoubleDataSource(signal));
            dds = new BufferedDoubleDataSource(signal);
            if (start > 0.0) {
                dds = new SequenceDoubleDataSource(new DoubleDataSource[]{new SilenceDoubleDataSource((long)(start * (double)format.getSampleRate())), dds});
            }
            audio.add(dds);
        }
        EnergyNormaliser powerNormaliser = null;
        if (referenceAudio.size() > 0) {
            powerNormaliser = new EnergyNormaliser(new SequenceDoubleDataSource(referenceAudio));
            System.err.println("Reference power: " + powerNormaliser.getReferencePower());
        }
        for (String spec : noiseSpecs) {
            String[] info = spec.split(":");
            double start = 0.0;
            if (info.length > 2) {
                start = Double.valueOf(info[1]);
            }
            double duration = maxDuration - start;
            if (info.length > 3) {
                duration = Double.valueOf(info[2]);
            }
            double db = Double.valueOf(info[info.length - 1]);
            BaseDoubleDataSource noise = new NoiseDoubleDataSource((long)(duration * (double)format.getSampleRate()), db);
            if (start > 0.0) {
                noise = new SequenceDoubleDataSource(new DoubleDataSource[]{new SilenceDoubleDataSource((long)(start * (double)format.getSampleRate())), noise});
            }
            audio.add(noise);
        }
        if (audio.size() > 0) {
            audioData = new MixerDoubleDataSource(audio).getAllData();
        }
        if (args.length == 0) {
            DDSAudioInputStream audioStream = new DDSAudioInputStream(new BufferedDoubleDataSource(audioData), format);
            String prefix = System.getProperty("prefix", "mixed_");
            File outFile = new File(prefix + ".wav");
            AudioSystem.write((AudioInputStream)audioStream, AudioFileFormat.Type.WAVE, outFile);
            System.out.println("Wrote " + outFile.getPath());
            System.exit(0);
        }
        double argsStart = Double.valueOf(System.getProperty("audio.args", "0"));
        for (int k = 0; k < args.length; ++k) {
            File inFile;
            AudioInputStream ais;
            ArrayList<BaseDoubleDataSource> result = new ArrayList<BaseDoubleDataSource>();
            if (audioData != null) {
                result.add(new BufferedDoubleDataSource(audioData));
            }
            if (!format.equals((ais = AudioSystem.getAudioInputStream(inFile = new File(args[k]))).getFormat())) {
                ais = AudioSystem.getAudioInputStream(format, ais);
            }
            DoubleDataSource dds = new AudioDoubleDataSource(ais);
            if (powerNormaliser != null) {
                dds = powerNormaliser.apply(dds);
            }
            if (argsStart > 0.0) {
                dds = new SequenceDoubleDataSource(new DoubleDataSource[]{new SilenceDoubleDataSource((long)(argsStart * (double)format.getSampleRate())), dds});
            }
            result.add((BaseDoubleDataSource)dds);
            MixerDoubleDataSource resultDDS = new MixerDoubleDataSource(result);
            DDSAudioInputStream resultStream = new DDSAudioInputStream(resultDDS, format);
            String prefix = System.getProperty("prefix", "mixed_");
            String filename = inFile.getName();
            filename = prefix + filename.substring(0, filename.lastIndexOf(46)) + ".wav";
            File outFile = new File(filename);
            AudioSystem.write((AudioInputStream)resultStream, AudioFileFormat.Type.WAVE, outFile);
            System.out.println("Wrote " + outFile.getPath());
        }
    }
}

