/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quartile {
    public static final int QUARTILE_WIDTH = 20;
    private double median;
    private double mean;
    private double standardDeviation;
    private double lowerQuartile;
    private double upperQuartile;
    private double lowerWhisker;
    private double upperWhisker;
    private double[] outliers;
    private Color color = SwingTools.LIGHT_BLUE;

    public Quartile(double median, double mean, double standardDeviation, double lowerQuartile, double upperQuartile, double lowerWhisker, double upperWhisker, double[] outliers) {
        this.median = median;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
        this.lowerQuartile = lowerQuartile;
        this.upperQuartile = upperQuartile;
        this.lowerWhisker = lowerWhisker;
        this.upperWhisker = upperWhisker;
        this.outliers = outliers;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public double getMin() {
        double min = Math.min(this.lowerWhisker, this.mean - this.standardDeviation);
        int i = 0;
        while (i < this.outliers.length) {
            min = Math.min(min, this.outliers[i]);
            ++i;
        }
        return min;
    }

    public double getMax() {
        double max = Math.max(this.upperWhisker, this.mean + this.standardDeviation);
        int i = 0;
        while (i < this.outliers.length) {
            max = Math.max(max, this.outliers[i]);
            ++i;
        }
        return max;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getLowerQuartile() {
        return this.lowerQuartile;
    }

    public double getUpperQuartile() {
        return this.upperQuartile;
    }

    public double getLowerWhisker() {
        return this.lowerWhisker;
    }

    public double getUpperWhisker() {
        return this.upperWhisker;
    }

    public double[] getOutliers() {
        return this.outliers;
    }

    public static Quartile calculateQuartile(DataTable table, int column) {
        double mean = 0.0;
        double squaredSum = 0.0;
        ArrayList<Double> values = new ArrayList<Double>();
        for (DataTableRow row : table) {
            double value = row.getValue(column);
            mean += value;
            squaredSum += value * value;
            values.add(value);
        }
        double standardDeviation = Math.sqrt((squaredSum /= (double)table.getNumberOfRows()) - (mean /= (double)table.getNumberOfRows()) * mean);
        return Quartile.calculateQuartile(mean, standardDeviation, values);
    }

    public static Quartile calculateQuartile(List<Double> values) {
        double mean = 0.0;
        double squaredSum = 0.0;
        for (double value : values) {
            mean += value;
            squaredSum += value * value;
        }
        double standardDeviation = Math.sqrt((squaredSum /= (double)values.size()) - (mean /= (double)values.size()) * mean);
        return Quartile.calculateQuartile(mean, standardDeviation, values);
    }

    private static Quartile calculateQuartile(double mean, double standardDeviation, List<Double> values) {
        Collections.sort(values);
        int medianIndex = (int)((double)values.size() * 0.5);
        int lowerQuartileIndex = (int)((double)values.size() * 0.25);
        int upperQuartileIndex = (int)((double)values.size() * 0.75);
        int lowerWhiskerIndex = (int)((double)values.size() * 0.05);
        int upperWhiskerIndex = (int)((double)values.size() * 0.95);
        double median = values.get(medianIndex);
        double lowerQuartile = values.get(lowerQuartileIndex);
        double upperQuartile = values.get(upperQuartileIndex);
        double lowerWhisker = values.get(lowerWhiskerIndex);
        double upperWhisker = values.get(upperWhiskerIndex);
        double[] outliers = null;
        int numberOfOutliers = lowerWhiskerIndex - 1 + (values.size() - upperWhiskerIndex);
        if (numberOfOutliers >= 0) {
            outliers = new double[numberOfOutliers];
            int counter = 0;
            int i = 0;
            while (i < lowerWhiskerIndex) {
                outliers[counter++] = values.get(i);
                ++i;
            }
            i = upperWhiskerIndex + 1;
            while (i < values.size()) {
                outliers[counter++] = values.get(i);
                ++i;
            }
        }
        return new Quartile(median, mean, standardDeviation, lowerQuartile, upperQuartile, lowerWhisker, upperWhisker, outliers);
    }

    public String toString() {
        return "Quartile (median: " + this.median + ", lower q: " + this.lowerQuartile + ", upper q: " + this.upperQuartile + "lower w: " + this.lowerWhisker + ", upper w: " + this.upperWhisker + ", mean: " + this.mean + ", sd: " + this.standardDeviation + ", number of outliers: " + this.outliers.length + ")";
    }
}

