/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.processeditor.CommentEditor;
import com.rapidminer.gui.processeditor.NewOperatorEditor;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.processeditor.XMLEditor;
import com.rapidminer.gui.properties.OperatorPropertyTable;
import com.rapidminer.gui.properties.SettingsChangeListener;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainProcessEditor
extends JSplitPane
implements ProcessEditor,
ChangeListener,
SettingsChangeListener {
    private static final long serialVersionUID = -2503689886544116347L;
    public static final int PARAMETERS = 0;
    public static final int XML = 1;
    public static final int COMMENT = 2;
    public static final int NEW_OPERATOR = 3;
    private static final String OPERATOR_TREE_ICON_NAME = "branch.png";
    private static final String PROPERTY_ICON_NAME = "form_blue_edit.png";
    private static final String XML_ICON_NAME = "text_code.png";
    private static final String COMMENT_ICON_NAME = "document_text.png";
    private static final String NEW_OPERATOR_ICON_NAME = "element_new.png";
    private static Icon operatorTreeIcon = null;
    private static Icon propertyIcon = null;
    private static Icon xmlIcon = null;
    private static Icon commentIcon = null;
    private static Icon newOperatorIcon = null;
    private OperatorTree operatorTree;
    private JTabbedPane operatorTreeTabs = new ExtendedJTabbedPane();
    private JTabbedPane editorTabs = new ExtendedJTabbedPane();
    private OperatorPropertyTable propertyTable;
    private XMLEditor xmlEditor;
    private CommentEditor commentEditor;
    private NewOperatorEditor newOperatorEditor;
    private JLabel propertyMessageLabel = new JLabel();
    private int lastIndex = 0;
    private MainFrame mainFrame;

    static {
        operatorTreeIcon = SwingTools.createIcon("16/branch.png");
        propertyIcon = SwingTools.createIcon("16/form_blue_edit.png");
        xmlIcon = SwingTools.createIcon("16/text_code.png");
        commentIcon = SwingTools.createIcon("16/document_text.png");
        newOperatorIcon = SwingTools.createIcon("16/element_new.png");
    }

    public MainProcessEditor(MainFrame mainFrame) {
        super(1);
        this.setResizeWeight(0.0);
        this.setBorder(null);
        this.mainFrame = mainFrame;
        this.operatorTree = new OperatorTree(mainFrame);
        this.operatorTree.setBorder(null);
        this.propertyTable = new OperatorPropertyTable(mainFrame, this.propertyMessageLabel);
        this.xmlEditor = new XMLEditor(mainFrame);
        this.commentEditor = new CommentEditor();
        this.newOperatorEditor = new NewOperatorEditor();
        ExtendedJScrollPane treeScrollPane = new ExtendedJScrollPane(this.operatorTree);
        treeScrollPane.setBorder(null);
        this.operatorTreeTabs.addTab("Operator Tree", operatorTreeIcon, treeScrollPane, "The operator tree of the current process.");
        this.add(this.operatorTreeTabs);
        JPanel propertyPanel = new JPanel(new BorderLayout());
        this.propertyTable.setOpaque(false);
        propertyPanel.add((Component)this.propertyTable, "Center");
        propertyPanel.add((Component)this.propertyMessageLabel, "South");
        ExtendedJScrollPane propertyPane = new ExtendedJScrollPane(propertyPanel);
        this.editorTabs.addTab("Parameters", propertyIcon, propertyPane, "Shows the parameters of the currently selected operator.");
        this.editorTabs.addTab("XML", xmlIcon, this.xmlEditor, "Shows the XML definition of the current process setup.");
        this.editorTabs.addTab("Comment", commentIcon, this.commentEditor, "Shows a comment editor for the currently selected operator.");
        this.editorTabs.addTab("New Operator", newOperatorIcon, this.newOperatorEditor, "Shows a grouped view of all available operators for dragging them into the operator tree.");
        this.add(this.editorTabs);
        this.editorTabs.addChangeListener(this);
    }

    private ProcessEditor getProcessEditor(int index) {
        switch (index) {
            case 1: {
                return this.xmlEditor;
            }
            case 2: {
                return this.commentEditor;
            }
        }
        return null;
    }

    public void setGroupSelectionDivider(int pos) {
        this.newOperatorEditor.setDividerLocation(pos);
    }

    public int getGroupSelectionDivider() {
        return this.newOperatorEditor.getDividerLocation();
    }

    public void processChanged(Operator operator) {
        this.operatorTree.setOperator(operator);
        this.propertyTable.setOperator(null);
        this.xmlEditor.processChanged(operator);
        this.commentEditor.setCurrentOperator(null);
    }

    public void setCurrentOperator(Operator current) {
        this.propertyTable.setOperator(current);
        this.xmlEditor.setCurrentOperator(current);
        this.commentEditor.setCurrentOperator(current);
    }

    public void validateProcess() {
    }

    public OperatorTree getOperatorTree() {
        return this.operatorTree;
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.propertyTable;
    }

    public XMLEditor getXMLEditor() {
        return this.xmlEditor;
    }

    public boolean isXMLViewActive() {
        return this.editorTabs.getSelectedIndex() == 1;
    }

    public boolean isDescriptionViewActive() {
        return this.editorTabs.getSelectedIndex() == 2;
    }

    public void changeToXMLEditor() {
        this.editorTabs.setSelectedIndex(1);
    }

    public void changeFromNewOperator2ParameterEditor() {
        if (this.editorTabs.getSelectedIndex() == 3) {
            this.editorTabs.setSelectedIndex(0);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.getPropertyTable().stopCurrentEditing();
        int currentIndex = this.editorTabs.getSelectedIndex();
        if (this.lastIndex == currentIndex) {
            return;
        }
        try {
            ProcessEditor newEditor;
            ProcessEditor lastEditor;
            if (currentIndex >= 0 && (lastEditor = this.getProcessEditor(this.lastIndex)) != null) {
                lastEditor.validateProcess();
            }
            if ((newEditor = this.getProcessEditor(currentIndex)) != null) {
                newEditor.processChanged(RapidMinerGUI.getMainFrame().getProcess().getRootOperator());
            }
            this.lastIndex = currentIndex;
        }
        catch (Exception ex) {
            switch (JOptionPane.showConfirmDialog(this, String.valueOf(ex.toString()) + Tools.getLineSeparator() + "Cancel to ignore changes, Ok to go on editing.", "Error", 2, 0)) {
                case 0: {
                    this.editorTabs.setSelectedIndex(this.lastIndex);
                    break;
                }
                default: {
                    ProcessEditor lastEditor = this.getProcessEditor(this.lastIndex);
                    if (lastEditor == null) break;
                    lastEditor.processChanged(RapidMinerGUI.getMainFrame().getProcess().getRootOperator());
                }
            }
        }
        this.mainFrame.enableActions();
    }

    public void settingsChanged(Properties properties) {
    }
}

