/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.AttributeFileCellEditor;
import com.rapidminer.gui.properties.ColorValueCellEditor;
import com.rapidminer.gui.properties.ConfigurationWizardValueCellEditor;
import com.rapidminer.gui.properties.DefaultPropertyKeyRenderer;
import com.rapidminer.gui.properties.DefaultPropertyValueCellEditor;
import com.rapidminer.gui.properties.InnerOperatorValueCellEditor;
import com.rapidminer.gui.properties.ListValueCellEditor;
import com.rapidminer.gui.properties.MatrixValueCellEditor;
import com.rapidminer.gui.properties.OperatorValueValueCellEditor;
import com.rapidminer.gui.properties.ParameterValueKeyCellEditor;
import com.rapidminer.gui.properties.PreviewValueCellEditor;
import com.rapidminer.gui.properties.PropertyKeyCellEditor;
import com.rapidminer.gui.properties.PropertyTableParameterChangeListener;
import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.gui.properties.SimpleFileValueCellEditor;
import com.rapidminer.gui.properties.TextValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeFile;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInnerOperator;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.parameter.ParameterTypeParameterValue;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypePreview;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.tools.LogService;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyTable
extends ExtendedJTable {
    private static final long serialVersionUID = -8510884721529372231L;
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>> knownValueEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyValueCellEditor>>();
    private static Map<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>> knownKeyEditors = new HashMap<Class<? extends ParameterType>, Class<? extends PropertyKeyCellEditor>>();
    private DefaultTableModel model;
    private List<PropertyValueCellEditor> valueEditors = new ArrayList<PropertyValueCellEditor>();
    private List<PropertyKeyCellEditor> keyEditors = new ArrayList<PropertyKeyCellEditor>();
    private List<String> toolTips = new ArrayList<String>();
    private String[] columnNames = new String[]{"Key", "Value"};
    private PropertyTableParameterChangeListener changeListener = new PropertyTableParameterChangeListener(this);

    static {
        PropertyTable.registerPropertyValueCellEditor(ParameterTypePassword.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeConfiguration.class, ConfigurationWizardValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypePreview.class, PreviewValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeColor.class, ColorValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeStringCategory.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeBoolean.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeInt.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeDouble.class, DefaultPropertyValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeAttributeFile.class, AttributeFileCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeFile.class, SimpleFileValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeValue.class, OperatorValueValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeInnerOperator.class, InnerOperatorValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeList.class, ListValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeMatrix.class, MatrixValueCellEditor.class);
        PropertyTable.registerPropertyValueCellEditor(ParameterTypeText.class, TextValueCellEditor.class);
        PropertyTable.registerPropertyKeyCellEditor(ParameterTypeParameterValue.class, ParameterValueKeyCellEditor.class);
    }

    public PropertyTable() {
        this(new String[]{"Key", "Value"});
    }

    public PropertyTable(String[] columnNames) {
        super(null, false, false);
        this.columnNames = columnNames;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(this.getRowHeight() + 10);
        this.setShowPopupMenu(false);
    }

    public abstract ParameterType getParameterType(int var1);

    public abstract Operator getOperator(int var1);

    public DefaultTableModel getDefaultModel() {
        return this.model;
    }

    protected static void updateEditorsAndRenderers(PropertyTable propertyTable) {
        propertyTable.valueEditors.clear();
        propertyTable.keyEditors.clear();
        propertyTable.toolTips.clear();
        int numberOfRows = propertyTable.getModel().getRowCount();
        int i = 0;
        while (i < numberOfRows) {
            String range;
            ParameterType type = propertyTable.getParameterType(i);
            propertyTable.valueEditors.add(PropertyTable.createPropertyValueCellEditor(type, propertyTable.getOperator(i)));
            PropertyKeyCellEditor keyEditor = PropertyTable.createPropertyKeyCellEditor(propertyTable, type, propertyTable.getOperator(i), propertyTable.changeListener);
            propertyTable.keyEditors.add(keyEditor);
            StringBuffer toolTip = new StringBuffer(type.getDescription());
            if (!(type instanceof ParameterTypeCategory) && !(type instanceof ParameterTypeStringCategory) && (range = type.getRange()) != null && range.trim().length() > 0) {
                toolTip.append(" (");
                toolTip.append(type.getRange());
                toolTip.append(")");
            }
            propertyTable.toolTips.add(SwingTools.transformToolTipText(toolTip.toString()));
            ++i;
        }
    }

    public int getNumberOfKeyEditors() {
        return this.keyEditors.size();
    }

    protected PropertyKeyCellEditor getKeyEditor(int index) {
        if (this.keyEditors.size() == 0) {
            return null;
        }
        return this.keyEditors.get(index);
    }

    protected void updateTableData(int rows) {
        this.model = new DefaultTableModel(this.columnNames, rows);
        this.setModel(this.model);
    }

    public int getNumberOfValueEditors() {
        return this.valueEditors.size();
    }

    public PropertyValueCellEditor getValueEditor(int index) {
        return this.valueEditors.get(index);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return this.valueEditors.get(row);
        }
        TableCellRenderer renderer = this.keyEditors.get(row);
        if (renderer instanceof TableCellEditor) {
            return (TableCellEditor)((Object)renderer);
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            PropertyValueCellEditor editor = this.valueEditors.get(row);
            if (!editor.useEditorAsRenderer()) {
                return super.getCellRenderer(row, column);
            }
            return editor;
        }
        if (this.keyEditors.size() == 0) {
            return null;
        }
        return this.keyEditors.get(row);
    }

    private String getToolTipText(int row) {
        if (row >= 0 && row < this.toolTips.size()) {
            return this.toolTips.get(row);
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        return this.getToolTipText(row);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = PropertyTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex == 0) {
                    return "The names of the parameters.";
                }
                return "The values of the parameters.";
            }
        };
    }

    public static void registerPropertyValueCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyValueCellEditor> editor) {
        knownValueEditors.put(typeClass, editor);
    }

    public static void registerPropertyKeyCellEditor(Class<? extends ParameterType> typeClass, Class<? extends PropertyKeyCellEditor> editor) {
        knownKeyEditors.put(typeClass, editor);
    }

    private static PropertyValueCellEditor createPropertyValueCellEditor(ParameterType type, Operator operator) {
        Class<? extends PropertyValueCellEditor> clazz = knownValueEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null) {
                if (!ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) break;
                clazz = knownValueEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyValueCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyValueCellEditor editor = constructor.newInstance(type);
                editor.setOperator(operator);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
            editor.setOperator(operator);
            return editor;
        }
        DefaultPropertyValueCellEditor editor = new DefaultPropertyValueCellEditor(type);
        editor.setOperator(operator);
        return editor;
    }

    private static PropertyKeyCellEditor createPropertyKeyCellEditor(PropertyTable table, ParameterType type, Operator operator, PropertyTableParameterChangeListener changeListener) {
        Class<? extends PropertyKeyCellEditor> clazz = knownKeyEditors.get(type.getClass());
        Class<?> usedClass = type.getClass();
        if (clazz == null) {
            while (clazz == null) {
                if (!ParameterType.class.isAssignableFrom(usedClass = usedClass.getSuperclass())) break;
                clazz = knownKeyEditors.get(usedClass);
            }
        }
        if (clazz != null) {
            try {
                Constructor<? extends PropertyKeyCellEditor> constructor = clazz.getConstructor(usedClass);
                PropertyKeyCellEditor editor = constructor.newInstance(type);
                if (editor instanceof ParameterValueKeyCellEditor) {
                    ((ParameterValueKeyCellEditor)editor).setParameterChangeListener(changeListener);
                }
                editor.setOperator(operator, table);
                return editor;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (SecurityException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (NoSuchMethodException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (IllegalArgumentException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().log("Cannot construct property editor: " + e, 6);
            }
            DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
            editor.setOperator(operator, table);
            return editor;
        }
        DefaultPropertyKeyRenderer editor = new DefaultPropertyKeyRenderer(type);
        editor.setOperator(operator, table);
        return editor;
    }
}

