/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.generator.BasicArithmeticOperationGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.ReciprocalValueGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.ExampleSetBasedFeatureOperator;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.ExampleSetBasedTournamentSelection;
import com.rapidminer.operator.features.construction.UnbalancedCrossover;
import com.rapidminer.operator.features.selection.SelectionCrossover;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratingGeneticAlgorithm
extends ExampleSetBasedFeatureOperator {
    public static final String[] SELECTION_SCHEMES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_TOURNAMENT_SIZE = "tournament_size";
    public static final String PARAMETER_START_TEMPERATURE = "start_temperature";
    public static final String PARAMETER_DYNAMIC_SELECTION_PRESSURE = "dynamic_selection_pressure";
    public static final String PARAMETER_KEEP_BEST_INDIVIDUAL = "keep_best_individual";
    public static final String PARAMETER_P_INITIALIZE = "p_initialize";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_USE_PLUS = "use_plus";
    public static final String PARAMETER_USE_DIFF = "use_diff";
    public static final String PARAMETER_USE_MULT = "use_mult";
    public static final String PARAMETER_USE_DIV = "use_div";
    public static final String PARAMETER_RECIPROCAL_VALUE = "reciprocal_value";
    private int numberOfIndividuals;
    private int maxGen;
    private int generationsWithoutImproval;

    public AbstractGeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    protected abstract ExampleSetBasedPopulationOperator getGeneratingPopulationOperator(ExampleSet var1) throws OperatorException;

    protected abstract ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet var1) throws OperatorException;

    protected List<ExampleSetBasedPopulationOperator> getPostProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<ExampleSetBasedPopulationOperator>();
    }

    @Override
    public final List<ExampleSetBasedPopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        ExampleSetBasedPopulationOperator mutation;
        LinkedList<ExampleSetBasedPopulationOperator> preOp = new LinkedList<ExampleSetBasedPopulationOperator>();
        ExampleSetBasedPopulationOperator crossover = this.getCrossoverPopulationOperator(input);
        if (crossover != null) {
            preOp.add(crossover);
        }
        if ((mutation = this.getMutationPopulationOperator(input)) != null) {
            preOp.add(mutation);
        }
        preOp.addAll(this.getPreProcessingPopulationOperators(input));
        return preOp;
    }

    @Override
    public final List<ExampleSetBasedPopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<ExampleSetBasedPopulationOperator> postOp = new LinkedList<ExampleSetBasedPopulationOperator>();
        this.numberOfIndividuals = this.getParameterAsInt(PARAMETER_POPULATION_SIZE);
        this.maxGen = this.getParameterAsInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS);
        this.generationsWithoutImproval = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        if (this.generationsWithoutImproval < 1) {
            this.generationsWithoutImproval = this.maxGen;
        }
        boolean keepBest = this.getParameterAsBoolean(PARAMETER_KEEP_BEST_INDIVIDUAL);
        boolean dynamicSelection = this.getParameterAsBoolean(PARAMETER_DYNAMIC_SELECTION_PRESSURE);
        postOp.add(new ExampleSetBasedTournamentSelection(this.numberOfIndividuals, this.getParameterAsDouble(PARAMETER_TOURNAMENT_SIZE), this.maxGen, dynamicSelection, keepBest, this.getRandom()));
        postOp.addAll(this.getPostProcessingPopulationOperators(input));
        return postOp;
    }

    @Override
    public boolean solutionGoodEnough(ExampleSetBasedPopulation pop) {
        return pop.getGeneration() >= this.maxGen || pop.getGenerationsWithoutImproval() >= this.generationsWithoutImproval;
    }

    @Override
    public ExampleSetBasedPopulation createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        ExampleSetBasedPopulation initP = new ExampleSetBasedPopulation();
        while (initP.getNumberOfIndividuals() < this.getParameterAsInt(PARAMETER_POPULATION_SIZE)) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet(es, null);
            for (Attribute attribute : nes.getAttributes()) {
                if (!(this.getRandom().nextDouble() > this.getParameterAsDouble(PARAMETER_P_INITIALIZE))) continue;
                nes.flipAttributeUsed(attribute);
            }
            if (nes.getNumberOfUsedAttributes() <= 0) continue;
            initP.add(new ExampleSetBasedIndividual(nes));
        }
        return initP;
    }

    protected List<ExampleSetBasedPopulationOperator> getPreProcessingPopulationOperators(ExampleSet exampleSet) throws OperatorException {
        LinkedList<ExampleSetBasedPopulationOperator> popOps = new LinkedList<ExampleSetBasedPopulationOperator>();
        ExampleSetBasedPopulationOperator generator = this.getGeneratingPopulationOperator(exampleSet);
        if (generator != null) {
            popOps.add(generator);
        }
        return popOps;
    }

    protected ExampleSetBasedPopulationOperator getCrossoverPopulationOperator(ExampleSet exampleSet) throws UndefinedParameterError {
        double pCrossover = this.getParameterAsDouble(PARAMETER_P_CROSSOVER);
        int crossoverType = this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE);
        return new UnbalancedCrossover(crossoverType, pCrossover, this.getRandom());
    }

    public List<FeatureGenerator> getGenerators() {
        ArrayList<FeatureGenerator> generators = new ArrayList<FeatureGenerator>();
        if (this.getParameterAsBoolean(PARAMETER_USE_PLUS)) {
            generators.add(new BasicArithmeticOperationGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIFF)) {
            generators.add(new BasicArithmeticOperationGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MULT)) {
            generators.add(new BasicArithmeticOperationGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIV)) {
            generators.add(new BasicArithmeticOperationGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_RECIPROCAL_VALUE)) {
            generators.add(new ReciprocalValueGenerator());
        }
        return generators;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble(PARAMETER_TOURNAMENT_SIZE, "The fraction of the current population which should be used as tournament members (only tournament selection).", 0.0, 1.0, 0.25));
        types.add(new ParameterTypeDouble(PARAMETER_START_TEMPERATURE, "The scaling temperature (only Boltzmann selection).", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_DYNAMIC_SELECTION_PRESSURE, "If set to true the selection pressure is increased to maximum during the complete optimization run (only Boltzmann and tournament selection).", true));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_BEST_INDIVIDUAL, "If set to true, the best individual of each generations is guaranteed to be selected for the next generation (elitist selection).", false));
        types.add(new ParameterTypeDouble(PARAMETER_P_INITIALIZE, "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5));
        type = new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_PLUS, "Generate sums.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIFF, "Generate differences.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MULT, "Generate products.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIV, "Generate quotients.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_RECIPROCAL_VALUE, "Generate reciprocal values.", true));
        return types;
    }
}

