/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.learner.rules.AccuracyCriterion;
import com.rapidminer.operator.learner.rules.Criterion;
import com.rapidminer.operator.learner.rules.Split;

public class NumericalSplitter {
    private Criterion criterion;
    private double minValue = 0.5;

    public NumericalSplitter() {
        this.criterion = new AccuracyCriterion();
    }

    public NumericalSplitter(Criterion criterion) {
        this.criterion = criterion;
    }

    public Split getBestSplit(ExampleSet inputSet, Attribute attribute, String labelName) {
        SortedExampleSet exampleSet = new SortedExampleSet((ExampleSet)inputSet.clone(), attribute, 0);
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        int labelIndex = labelAttribute.getMapping().mapString(labelName);
        double oldLabel = Double.NaN;
        double bestSplit = Double.NaN;
        double lastValue = Double.NaN;
        double bestBenefit = Double.NEGATIVE_INFINITY;
        double bestTotalWeight = 0.0;
        int bestSplitType = 0;
        this.criterion.reinitOnlineCounting(exampleSet);
        for (Example e : exampleSet) {
            double currentValue = e.getValue(attribute);
            double label = e.getValue(labelAttribute);
            if (Double.isNaN(oldLabel) || oldLabel != label && lastValue != currentValue) {
                double splitValue = (lastValue + currentValue) / 2.0;
                double[] benefits = labelName == null ? this.criterion.getOnlineBenefit(e) : this.criterion.getOnlineBenefit(e, labelIndex);
                if (benefits[0] > this.minValue && benefits[0] > 0.0 && benefits[1] > 0.0 && (benefits[0] > bestBenefit || benefits[0] == bestBenefit && benefits[1] > bestTotalWeight)) {
                    bestBenefit = benefits[0];
                    bestSplit = splitValue;
                    bestTotalWeight = benefits[1];
                    bestSplitType = 0;
                }
                if (benefits[2] > this.minValue && benefits[2] > 0.0 && benefits[3] > 0.0 && (benefits[2] > bestBenefit || benefits[2] == bestBenefit && benefits[3] > bestTotalWeight)) {
                    bestBenefit = benefits[2];
                    bestSplit = splitValue;
                    bestTotalWeight = benefits[3];
                    bestSplitType = 1;
                }
                oldLabel = label;
            }
            lastValue = currentValue;
            this.criterion.update(e);
        }
        return new Split(bestSplit, new double[]{bestBenefit, bestTotalWeight}, bestSplitType);
    }
}

