/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.charts.ParetoChartPlotter;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.report.Renderable;
import java.awt.Component;
import java.awt.Graphics;

public class LiftParetoChart
extends ResultObjectAdapter
implements Renderable {
    private static final long serialVersionUID = 7559555964863472326L;
    private transient ParetoChartPlotter plotter = new ParetoChartPlotter();
    private DataTable liftChartData;
    private String targetValue;
    private boolean showBarLabels;
    private boolean showCumulativeLabels;
    private boolean rotateLabels;

    public LiftParetoChart(DataTable liftChartData, String targetValue, boolean showBarLabels, boolean showCumulativeLabels, boolean rotateLabels) {
        this.liftChartData = liftChartData;
        this.targetValue = targetValue;
        this.showBarLabels = showBarLabels;
        this.showCumulativeLabels = showCumulativeLabels;
        this.rotateLabels = rotateLabels;
    }

    public DataTable getLiftChartData() {
        return this.liftChartData;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public boolean showBarLabels() {
        return this.showBarLabels;
    }

    public boolean showCumulativeLabels() {
        return this.showCumulativeLabels;
    }

    public boolean rotateLabels() {
        return this.rotateLabels;
    }

    public String getName() {
        return "Lift Chart";
    }

    public String toString() {
        return "A visualization of the discretized confidences together with the counts for " + this.targetValue + ".";
    }

    public String getExtension() {
        return "lpc";
    }

    public String getFileDescription() {
        return "Lift Pareto Chart files";
    }

    public Component getVisualizationComponent(IOContainer container) {
        this.plotter.setDataTable(this.liftChartData);
        this.plotter.setAxis(0, 0);
        this.plotter.setPlotColumn(1, true);
        this.plotter.setCountValue(this.targetValue);
        this.plotter.setSortingDirection(0);
        this.plotter.setShowBarLabels(this.showBarLabels);
        this.plotter.setShowCumulativeLabels(this.showCumulativeLabels);
        this.plotter.setRotateLabels(this.rotateLabels);
        return this.plotter;
    }

    public void prepareRendering() {
        this.plotter.prepareRendering();
    }

    public void finishRendering() {
        this.plotter.finishRendering();
    }

    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    public void render(Graphics graphics, int width, int height) {
        this.plotter.render(graphics, width, height);
    }
}

