/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnsureMonotonicity
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE = "attribute";

    public EnsureMonotonicity(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int[] elements = new int[exampleSet.size()];
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE));
        }
        double lastValue = Double.NaN;
        int index = 0;
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (Double.isNaN(lastValue)) {
                elements[index] = 0;
                lastValue = value;
            } else if (value >= lastValue) {
                elements[index] = 0;
                lastValue = value;
            } else {
                elements[index] = 1;
            }
            ++index;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(elements, 2));
        result.selectSingleSubset(0);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE, "The name of the attribute on which the monotonicity ensurance should be performed.", false));
        return types;
    }
}

