/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class IntervalSecondData {
    public final long units;
    public final int nanos;

    public static IntervalSecondData newIntervalDay(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 24L * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalHour(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalMinute(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalSeconds(long l, IntervalType intervalType) {
        return new IntervalSecondData(l, 0, intervalType);
    }

    public IntervalSecondData(long l, int n, IntervalType intervalType) {
        if (l >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l;
        this.nanos = n;
    }

    public IntervalSecondData(long l, int n) {
        this.units = l;
        this.nanos = n;
    }

    public IntervalSecondData(long l, long l2, IntervalType intervalType, boolean bl) {
        long l3;
        if (l2 >= 1000000000L) {
            l3 = l2 / 1000000000L;
            l2 %= 1000000000L;
            l += l3;
        } else if (l2 <= -1000000000L) {
            l3 = -l2 / 1000000000L;
            l2 = -(-l2 % 1000000000L);
            l -= l3;
        }
        int n = DTIType.nanoScaleFactors[intervalType.scale];
        l2 /= (long)n;
        if (l > 0L && (l2 *= (long)n) < 0L) {
            l2 += 1000000000L;
            --l;
        } else if (l < 0L && l2 > 0L) {
            l2 -= 1000000000L;
            ++l;
        }
        n = DTIType.yearToSecondFactors[intervalType.endPartIndex];
        l /= (long)n;
        if ((l *= (long)n) >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l;
        this.nanos = (int)l2;
    }

    public boolean equals(Object object) {
        if (object instanceof IntervalSecondData) {
            return this.units == ((IntervalSecondData)object).units && this.nanos == ((IntervalSecondData)object).nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.units ^ this.nanos;
    }

    public int compareTo(IntervalSecondData intervalSecondData) {
        long l = this.units - intervalSecondData.units;
        if (l == 0L && (l = (long)(this.nanos - intervalSecondData.nanos)) == 0L) {
            return 0;
        }
        return l > 0L ? 1 : -1;
    }

    public long getSeconds() {
        return this.units;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION.convertToString(this);
    }
}

