/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.graphs.DefaultObjectViewer;
import com.rapidminer.gui.graphs.GraphCreatorAdaptor;
import com.rapidminer.gui.graphs.GraphObjectViewer;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.SortableEdge;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityGraphCreator
extends GraphCreatorAdaptor {
    private Factory<String> edgeFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "E" + this.i++;
        }
    };
    private JSlider distanceSlider = new JSlider(0, 0, 1000, 100){
        private static final long serialVersionUID = -6931545310805789589L;

        public Dimension getMinimumSize() {
            return new Dimension(40, (int)super.getMinimumSize().getHeight());
        }

        public Dimension getPreferredSize() {
            return new Dimension(40, (int)super.getPreferredSize().getHeight());
        }

        public Dimension getMaximumSize() {
            return new Dimension(40, (int)super.getMaximumSize().getHeight());
        }
    };
    private Graph<String, String> graph;
    private DistanceMeasure measure;
    private ExampleSet exampleSet;
    private Map<String, String> edgeLabelMap = new HashMap<String, String>();
    private Map<String, Double> edgeStrengthMap = new HashMap<String, Double>();
    private DefaultObjectViewer objectViewer = new DefaultObjectViewer();

    public SimilarityGraphCreator(DistanceMeasure measure, ExampleSet exampleSet) {
        this.measure = measure;
        this.exampleSet = exampleSet;
    }

    @Override
    public Graph<String, String> createGraph() {
        this.graph = new UndirectedSparseGraph();
        Attribute id = this.exampleSet.getAttributes().getId();
        for (Example example : this.exampleSet) {
            this.graph.addVertex((Object)example.getValueAsString(id));
        }
        this.addEdges();
        return this.graph;
    }

    @Override
    public String getEdgeName(String id) {
        return this.edgeLabelMap.get(id);
    }

    @Override
    public String getVertexName(String id) {
        return id;
    }

    @Override
    public String getVertexToolTip(String id) {
        return id;
    }

    @Override
    public int getLabelOffset() {
        return -1;
    }

    @Override
    public int getNumberOfOptionComponents() {
        return 2;
    }

    @Override
    public JComponent getOptionComponent(final GraphViewer viewer, int index) {
        if (index == 0) {
            return new JLabel("Number of Edges:");
        }
        if (index == 1) {
            this.distanceSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!SimilarityGraphCreator.this.distanceSlider.getValueIsAdjusting()) {
                        SimilarityGraphCreator.this.addEdges();
                        viewer.updateLayout();
                    }
                }
            });
            return this.distanceSlider;
        }
        return null;
    }

    private void addEdges() {
        Iterator<String> e = this.edgeLabelMap.keySet().iterator();
        while (e.hasNext()) {
            this.graph.removeEdge((Object)e.next());
        }
        this.edgeLabelMap.clear();
        boolean isDistance = this.measure.isDistance();
        Attribute id = this.exampleSet.getAttributes().getId();
        LinkedList<SortableEdge> sortableEdges = new LinkedList<SortableEdge>();
        int i = 0;
        while (i < this.exampleSet.size()) {
            Example example = this.exampleSet.getExample(i);
            int j = i + 1;
            while (j < this.exampleSet.size()) {
                Example comExample = this.exampleSet.getExample(j);
                if (isDistance) {
                    sortableEdges.add(new SortableEdge(example.getValueAsString(id), comExample.getValueAsString(id), null, this.measure.calculateDistance(example, comExample), -1));
                } else {
                    sortableEdges.add(new SortableEdge(example.getValueAsString(id), comExample.getValueAsString(id), null, this.measure.calculateSimilarity(example, comExample), 1));
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(sortableEdges);
        int numberOfEdges = this.distanceSlider.getValue();
        int counter = 0;
        double minStrength = Double.POSITIVE_INFINITY;
        double maxStrength = Double.NEGATIVE_INFINITY;
        HashMap<String, Double> strengthMap = new HashMap<String, Double>();
        for (SortableEdge sortableEdge : sortableEdges) {
            if (counter > numberOfEdges) break;
            String idString = (String)this.edgeFactory.create();
            this.graph.addEdge((Object)idString, (Object)sortableEdge.getFirstVertex(), (Object)sortableEdge.getSecondVertex(), EdgeType.UNDIRECTED);
            this.edgeLabelMap.put(idString, Tools.formatIntegerIfPossible(sortableEdge.getEdgeValue()));
            double strength = sortableEdge.getEdgeValue();
            minStrength = Math.min(minStrength, strength);
            maxStrength = Math.max(maxStrength, strength);
            strengthMap.put(idString, strength);
            ++counter;
        }
        for (String idString : strengthMap.keySet()) {
            this.edgeStrengthMap.put(idString, ((Double)strengthMap.get(idString) - minStrength) / (maxStrength - minStrength));
        }
    }

    @Override
    public boolean showEdgeLabelsDefault() {
        return false;
    }

    @Override
    public boolean showVertexLabelsDefault() {
        return false;
    }

    @Override
    public double getEdgeStrength(String id) {
        Double value = this.edgeStrengthMap.get(id);
        if (value == null) {
            return 1.0;
        }
        if (Double.isNaN(value)) {
            return 1.0;
        }
        return value;
    }

    @Override
    public int getEdgeShape() {
        return 1;
    }

    @Override
    public Object getObject(String id) {
        return id;
    }

    @Override
    public GraphObjectViewer getObjectViewer() {
        return this.objectViewer;
    }
}

