/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class ExtendedTriStateCheckBox
extends JCheckBox {
    private static final long serialVersionUID = 8924026691487760529L;
    private final TristateDecorator model;

    public ExtendedTriStateCheckBox(String text, Icon icon, Boolean initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ExtendedTriStateCheckBox.this.grabFocus();
                ExtendedTriStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent e) {
                ExtendedTriStateCheckBox.this.grabFocus();
                ExtendedTriStateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public ExtendedTriStateCheckBox(String text, Boolean initial) {
        this(text, (Icon)null, initial);
    }

    public ExtendedTriStateCheckBox(String text) {
        this(text, (Boolean)null);
    }

    public ExtendedTriStateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener l) {
    }

    public void setState(Boolean state) {
        this.model.setState(state);
    }

    public Boolean getState() {
        return this.model.getState();
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(Boolean state) {
            if (state == Boolean.FALSE) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == Boolean.TRUE) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(false);
            }
        }

        private Boolean getState() {
            if (this.isSelected() && !this.isArmed()) {
                return Boolean.TRUE;
            }
            if (this.isSelected() && this.isArmed()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private void nextState() {
            Boolean current = this.getState();
            if (current == Boolean.FALSE) {
                this.setState(Boolean.TRUE);
            } else if (current == Boolean.TRUE) {
                this.setState(null);
            } else if (current == null) {
                this.setState(Boolean.FALSE);
            }
        }

        public void setArmed(boolean b) {
        }

        public boolean isFocusTraversable() {
            return this.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.other.setEnabled(b);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

