/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FileChooserTextField
extends JPanel {
    private static final long serialVersionUID = -881870566556416203L;
    private final JFileChooser chooser = new JFileChooser();
    private final JTextField fileField = new JTextField();
    private final JButton fileChooserButton = new JButton("...");

    public FileChooserTextField(final Component root, final boolean dirMode) {
        super(new GridBagLayout());
        this.fileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg) {
                FileChooserTextField.this.fileField.setCaretPosition(0);
            }
        });
        if (dirMode) {
            this.fileField.setToolTipText("Path to a directory");
        } else {
            this.fileField.setToolTipText("Path to a single file");
        }
        this.fileChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (dirMode) {
                        FileChooserTextField.this.chooser.setFileSelectionMode(1);
                    } else {
                        FileChooserTextField.this.chooser.setFileSelectionMode(0);
                    }
                    int returnVal = FileChooserTextField.this.chooser.showOpenDialog(root);
                    if (returnVal == 0) {
                        FileChooserTextField.this.fileField.setText(FileChooserTextField.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.fileChooserButton.setToolTipText("Open file chooser");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = -1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(7, 0, 7, 7);
        this.add((Component)this.fileField, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(7, 0, 7, 0);
        this.add((Component)this.fileChooserButton, gbc);
    }

    public void setEnabled(boolean arg0) {
        this.fileField.setEnabled(arg0);
        this.fileChooserButton.setEnabled(arg0);
    }

    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    public JTextField getTextField() {
        return this.fileField;
    }
}

