/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;

public class KernelGaussianCombination
extends Kernel {
    private static final long serialVersionUID = 6080834703694525403L;
    private double sigma1 = 1.0;
    private double sigma2 = 0.0;
    private double sigma3 = 2.0;

    public String toString() {
        return "gaussian_combination(s1=" + this.sigma1 + ",s2=" + this.sigma2 + ",s3=" + this.sigma3 + ")";
    }

    public void setParameters(double sigma1, double sigma2, double sigma3) {
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.sigma3 = sigma3;
    }

    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double norm2 = this.norm2(x_index, x_att, y_index, y_att);
        double exp1 = this.sigma1 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma1);
        double exp2 = this.sigma2 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma2);
        double exp3 = this.sigma3 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma3);
        return exp1 + exp2 - exp3;
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer norm2Expression = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                norm2Expression.append(String.valueOf(valueString) + " * " + valueString);
            } else {
                norm2Expression.append(" + " + valueString + " * " + valueString);
            }
            first = false;
            ++i;
        }
        String exp1 = this.sigma1 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma1 + ")";
        String exp2 = this.sigma2 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma2 + ")";
        String exp3 = this.sigma3 == 0.0 ? "" : "exp(-1 * " + norm2Expression.toString() + " / " + this.sigma3 + ")";
        StringBuffer result = new StringBuffer();
        if (exp1.length() > 0) {
            result.append(exp1);
        }
        if (exp2.length() > 0) {
            if (result.length() > 0) {
                result.append(" + " + exp2);
            } else {
                result.append(exp2);
            }
        }
        if (exp3.length() > 0) {
            if (result.length() > 0) {
                result.append(" - " + exp3);
            } else {
                result.append("-" + exp3);
            }
        }
        return result.toString();
    }
}

