/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.FileReader;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FramewiseMerger;
import marytts.signalproc.process.LSFInterpolator;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.text.ESTTextfileDoubleDataSource;
import marytts.util.data.text.LabelfileDoubleDataSource;
import marytts.util.io.FileUtils;

public class PitchLsfInterpolator {
    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        double r = Double.parseDouble(System.getProperty("r", "0.5"));
        String file1 = null;
        String pm1 = null;
        String file2 = null;
        String pm2 = null;
        BaseDoubleDataSource label1 = null;
        BaseDoubleDataSource label2 = null;
        if (args.length == 4) {
            file1 = args[0];
            pm1 = args[1];
            file2 = args[2];
            pm2 = args[3];
        } else if (args.length == 6) {
            double[] labelData2;
            file1 = args[0];
            pm1 = args[1];
            label1 = new LabelfileDoubleDataSource(new FileReader(args[2]));
            file2 = args[3];
            pm2 = args[4];
            label2 = new LabelfileDoubleDataSource(new FileReader(args[5]));
            double[] labelData1 = label1.getAllData();
            if (labelData1.length != (labelData2 = label2.getAllData()).length) {
                System.err.println("Warning: Number of labels is different!");
                System.err.println(args[2] + ":");
                System.err.println(FileUtils.getFileAsString(new File(args[2]), "ASCII"));
                System.err.println(args[5] + ":");
                System.err.println(FileUtils.getFileAsString(new File(args[5]), "ASCII"));
            }
            label1 = new BufferedDoubleDataSource(labelData1);
            label2 = new BufferedDoubleDataSource(labelData2);
        } else {
            System.out.println("Usage: java [-Dr=<mixing ratio> marytts.signalproc.process.PitchLSFInterpolator signal.wav signal.pm [signal.lab] other.wav other.pm [other.lab]");
            System.out.println("where");
            System.out.println("    <mixing ratio> is a value between 0.0 and 1.0 indicating how much of \"other\" is supposed to be mixed into \"signal\"");
            System.exit(1);
        }
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(file1));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        ESTTextfileDoubleDataSource pitchmarks = new ESTTextfileDoubleDataSource(new FileReader(pm1));
        AudioInputStream otherAudio = AudioSystem.getAudioInputStream(new File(file2));
        AudioDoubleDataSource otherSource = new AudioDoubleDataSource(otherAudio);
        ESTTextfileDoubleDataSource otherPitchmarks = new ESTTextfileDoubleDataSource(new FileReader(pm2));
        int predictionOrder = Integer.getInteger("signalproc.lpcanalysisresynthesis.predictionorder", 20);
        FramewiseMerger foas = new FramewiseMerger(signal, pitchmarks, samplingRate, label1, otherSource, otherPitchmarks, samplingRate, label2, new LSFInterpolator(predictionOrder, r));
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
        String outFileName = file1.substring(0, file1.length() - 4) + "_" + file2.substring(file2.lastIndexOf("\\") + 1, file2.length() - 4) + "_" + r + "_ps.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        long endTime = System.currentTimeMillis();
        int audioDuration = (int)((double)AudioSystem.getAudioFileFormat(new File(file1)).getFrameLength() / (double)samplingRate * 1000.0);
        System.out.println("Pitch-synchronous LSF-based interpolatin took " + (endTime - startTime) + " ms for " + audioDuration + " ms of audio");
    }
}

