/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.util.Iterator;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.Syllable;
import marytts.unitselection.data.SyllableIterator;

public class Sentence
implements Iterable<Syllable> {
    private FeatureFileReader features;
    private int firstUnitIndex;
    private int lastUnitIndex;

    public Sentence(FeatureFileReader features, int firstUnitIndex, int lastUnitIndex) {
        this.features = features;
        this.firstUnitIndex = firstUnitIndex;
        this.lastUnitIndex = lastUnitIndex;
    }

    public int getFirstUnitIndex() {
        return this.firstUnitIndex;
    }

    public int getLastUnitIndex() {
        return this.lastUnitIndex;
    }

    @Override
    public Iterator<Syllable> iterator() {
        return new SyllableIterator(this.features, this.firstUnitIndex, this.lastUnitIndex);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Sentence)) {
            return false;
        }
        Sentence other = (Sentence)o;
        return this.features.equals(other.features) && this.firstUnitIndex == other.firstUnitIndex && this.lastUnitIndex == other.lastUnitIndex;
    }
}

