/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.data;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.AbstractDataTableTableRenderer;
import com.rapidminer.gui.viewer.DataViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import java.awt.Component;

public class ExampleSetDataRenderer
extends AbstractDataTableTableRenderer {
    public static final String RENDERER_NAME = "Data View";

    public String getName() {
        return RENDERER_NAME;
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        return new DataViewer(exampleSet, true);
    }

    public DataTable getDataTable(Object renderable, IOContainer container) {
        ExampleSet exampleSet = (ExampleSet)renderable;
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException missingIOObjectException) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(exampleSet, weights);
    }
}

