/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.gui.dialog.IndividualSelector;
import com.rapidminer.gui.dialog.StopDialog;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationEvaluator;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.PopulationPlotter;
import com.rapidminer.operator.features.SimplePopulationEvaluator;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureOperator
extends OperatorChain {
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_SHOW_STOP_DIALOG = "show_stop_dialog";
    public static final String PARAMETER_USER_RESULT_INDIVIDUAL_SELECTION = "user_result_individual_selection";
    public static final String PARAMETER_SHOW_POPULATION_PLOTTER = "show_population_plotter";
    public static final String PARAMETER_PLOT_GENERATIONS = "plot_generations";
    public static final String PARAMETER_CONSTRAINT_DRAW_RANGE = "constraint_draw_range";
    public static final String PARAMETER_DRAW_DOMINATED_POINTS = "draw_dominated_points";
    public static final String PARAMETER_POPULATION_CRITERIA_DATA_FILE = "population_criteria_data_file";
    public static final String PARAMETER_MAXIMAL_FITNESS = "maximal_fitness";
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private ExampleSet exampleSet;
    private Population population;
    private PopulationEvaluator populationEvaluator;
    private double maximalFitness = Double.POSITIVE_INFINITY;
    private boolean checkForMaximalFitness = true;
    private RandomGenerator random;

    public FeatureOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("generation", "The number of the current generation."){

            public double getDoubleValue() {
                if (FeatureOperator.this.population == null) {
                    return 0.0;
                }
                return FeatureOperator.this.population.getGeneration();
            }
        });
        this.addValue(new ValueDouble("performance", "The performance of the current generation (main criterion)."){

            public double getDoubleValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                if (FeatureOperator.this.population.getCurrentBestPerformance() == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = FeatureOperator.this.population.getCurrentBestPerformance();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new ValueDouble("best", "The performance of the best individual ever (main criterion)."){

            public double getDoubleValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = FeatureOperator.this.population.getBestPerformanceEver();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new ValueDouble("average_length", "The average number of attributes."){

            public double getDoubleValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                double lengthSum = 0.0;
                int i = 0;
                while (i < FeatureOperator.this.population.getNumberOfIndividuals()) {
                    lengthSum += (double)FeatureOperator.this.population.get(i).getNumberOfUsedAttributes();
                    ++i;
                }
                return lengthSum / (double)FeatureOperator.this.population.getNumberOfIndividuals();
            }
        });
        this.addValue(new ValueDouble("best_length", "The number of attributes of the best example set."){

            public double getDoubleValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                Individual individual = FeatureOperator.this.population.getBestIndividualEver();
                if (individual != null) {
                    return individual.getNumberOfUsedAttributes();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueString("feature_names", "The names of the used features in the current iteration."){

            public String getStringValue() {
                if (FeatureOperator.this.population == null) {
                    return "?";
                }
                Individual individual = FeatureOperator.this.population.getBestIndividualEver();
                if (individual != null) {
                    double[] weights = individual.getWeights();
                    String[] names = Tools.getRegularAttributeNames(FeatureOperator.this.exampleSet);
                    StringBuffer result = new StringBuffer();
                    boolean first = true;
                    int i = 0;
                    while (i < weights.length) {
                        if (weights[i] > 0.0) {
                            if (!first) {
                                result.append(", ");
                            }
                            result.append(names[i]);
                            first = false;
                        }
                        ++i;
                    }
                    return result.toString();
                }
                return "?";
            }
        });
    }

    public abstract Population createInitialPopulation(ExampleSet var1) throws OperatorException;

    public abstract List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract boolean solutionGoodEnough(Population var1) throws OperatorException;

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class});
    }

    protected RandomGenerator getRandom() {
        return this.random;
    }

    protected Population getPopulation() {
        return this.population;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        this.maximalFitness = this.getParameterAsDouble(PARAMETER_MAXIMAL_FITNESS);
        ExampleSet es = this.getInput(ExampleSet.class);
        this.populationEvaluator = this.getPopulationEvaluator(es);
        if (es.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 125, 0, 1);
        }
        this.exampleSet = es;
        List<PopulationOperator> preOps = this.getPreEvaluationPopulationOperators(es);
        List<PopulationOperator> postOps = this.getPostEvaluationPopulationOperators(es);
        boolean userDialogOk = true;
        StopDialog stopDialog = null;
        if (this.getParameterAsBoolean(PARAMETER_SHOW_STOP_DIALOG)) {
            stopDialog = new StopDialog("Stop Dialog", "<html>Press the stop button to abort the search for best feature space.<br>The best individual found so far is returned.</html>");
            stopDialog.setVisible(true);
        }
        this.population = this.createInitialPopulation(es);
        this.log("Initial population has " + this.population.getNumberOfIndividuals() + " individuals.");
        this.evaluate(this.population);
        PopulationPlotter popPlotter = null;
        this.checkForStop();
        this.population.updateEvaluation();
        if (this.getParameterAsBoolean(PARAMETER_SHOW_POPULATION_PLOTTER)) {
            popPlotter = new PopulationPlotter(this.exampleSet, this.getParameterAsInt(PARAMETER_PLOT_GENERATIONS), this.getParameterAsBoolean(PARAMETER_CONSTRAINT_DRAW_RANGE), this.getParameterAsBoolean(PARAMETER_DRAW_DOMINATED_POINTS));
            popPlotter.operate(this.population);
        }
        this.inApplyLoop();
        while (userDialogOk && !this.solutionGoodEnough(this.population) && !this.isMaximumReached()) {
            this.population.nextGeneration();
            this.applyOpList(preOps, this.population);
            this.log(String.valueOf(com.rapidminer.tools.Tools.ordinalNumber(this.population.getGeneration())) + " generation has " + this.population.getNumberOfIndividuals() + " individuals.");
            this.log("Evaluating " + com.rapidminer.tools.Tools.ordinalNumber(this.population.getGeneration()) + " population.");
            this.evaluate(this.population);
            this.checkForStop();
            this.population.updateEvaluation();
            this.applyOpList(postOps, this.population);
            if (popPlotter != null) {
                popPlotter.operate(this.population);
            }
            userDialogOk = stopDialog == null ? true : stopDialog.isStillRunning();
            this.inApplyLoop();
        }
        if (stopDialog != null) {
            stopDialog.setVisible(false);
            stopDialog.dispose();
        }
        this.checkForStop();
        this.applyOpList(postOps, this.population);
        if (this.isParameterSet(PARAMETER_POPULATION_CRITERIA_DATA_FILE)) {
            SimpleDataTable finalStatistics = PopulationPlotter.createDataTable(this.population);
            PopulationPlotter.fillDataTable(finalStatistics, new HashMap<String, double[]>(), this.population, this.getParameterAsBoolean(PARAMETER_DRAW_DOMINATED_POINTS));
            File outFile = this.getParameterAsFile(PARAMETER_POPULATION_CRITERIA_DATA_FILE, true);
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(outFile));
                    finalStatistics.write(out);
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, 303, outFile, e.getMessage());
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        Individual bestEver = null;
        if (this.getParameterAsBoolean(PARAMETER_USER_RESULT_INDIVIDUAL_SELECTION)) {
            IndividualSelector selector = new IndividualSelector(this.exampleSet, this.population);
            selector.setVisible(true);
            bestEver = selector.getSelectedIndividual();
            if (bestEver == null) {
                this.logWarning("No individual selected. Using individual with highest fitness for main criterion...");
            }
        }
        if (bestEver == null) {
            bestEver = this.population.getBestIndividualEver();
        }
        double[] weights = bestEver.getWeights();
        int a = 0;
        AttributeWeights attributeWeights = new AttributeWeights();
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            double weight = weights[a];
            if (Double.isNaN(weight)) {
                weight = 1.0;
            }
            attributeWeights.setWeight(attribute.getName(), weight);
            ++a;
        }
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            attributeWeights.normalize();
        }
        IOObject[] result = new IOObject[]{FeatureOperator.createCleanClone(this.exampleSet, weights), attributeWeights, bestEver.getPerformance()};
        this.population.clear();
        this.population = null;
        this.exampleSet = null;
        return result;
    }

    public static ExampleSet createCleanClone(ExampleSet exampleSet, double[] weights) {
        AttributeWeightedExampleSet clone = new AttributeWeightedExampleSet(exampleSet, null);
        int a = 0;
        for (Attribute attribute : clone.getAttributes()) {
            clone.setWeight(attribute, weights[a++]);
        }
        return clone.createCleanClone();
    }

    void applyOpList(List opList, Population population) throws OperatorException {
        ListIterator i = opList.listIterator();
        while (i.hasNext()) {
            PopulationOperator op = (PopulationOperator)i.next();
            if (!op.performOperation(population.getGeneration())) continue;
            try {
                op.operate(population);
                int k = 0;
                while (k < population.getNumberOfIndividuals()) {
                    if (population.get(k).getNumberOfUsedAttributes() <= 0) {
                        this.logError("Population operator " + op + " has produced an example set without attributes!");
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                throw new UserError((Operator)this, (Throwable)e, 108, e.toString());
            }
        }
    }

    protected void evaluate(Population population) throws OperatorException {
        this.populationEvaluator.evaluate(population);
    }

    private boolean isMaximumReached() {
        if (this.checkForMaximalFitness) {
            PerformanceVector pv = this.population.getBestPerformanceEver();
            if (pv == null) {
                return false;
            }
            if (pv.getMainCriterion().getFitness() == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (pv.getMainCriterion().getMaxFitness() == pv.getMainCriterion().getFitness()) {
                return true;
            }
            return pv.getMainCriterion().getFitness() >= this.maximalFitness;
        }
        return false;
    }

    protected void setCheckForMaximum(boolean checkForMaximalFitness) {
        this.checkForMaximalFitness = checkForMaximalFitness;
    }

    protected boolean getCheckForMaximum() {
        return this.checkForMaximalFitness;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Indicates if the final weights should be normalized.", true));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_SHOW_STOP_DIALOG, "Determines if a dialog with a button should be displayed which stops the run: the best individual is returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USER_RESULT_INDIVIDUAL_SELECTION, "Determines if the user wants to select the final result individual from the last population.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_POPULATION_PLOTTER, "Determines if the current population should be displayed in performance space.", false));
        types.add(new ParameterTypeInt(PARAMETER_PLOT_GENERATIONS, "Update the population plotter in these generations.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(PARAMETER_CONSTRAINT_DRAW_RANGE, "Determines if the draw range of the population plotter should be constrained between 0 and 1.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_DRAW_DOMINATED_POINTS, "Determines if only points which are not Pareto dominated should be painted.", true));
        types.add(new ParameterTypeFile(PARAMETER_POPULATION_CRITERIA_DATA_FILE, "The path to the file in which the criteria data of the final population should be saved.", "cri", true));
        types.add(new ParameterTypeDouble(PARAMETER_MAXIMAL_FITNESS, "The optimization will stop if the fitness reaches the defined maximum.", 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        return types;
    }

    protected PopulationEvaluator getPopulationEvaluator(ExampleSet exampleSet) throws UndefinedParameterError {
        return new SimplePopulationEvaluator(this, this.getInput(), exampleSet);
    }
}

