/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeightSelection
extends Operator {
    public static final String PARAMETER_WEIGHT = "weight";
    public static final String PARAMETER_WEIGHT_RELATION = "weight_relation";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_DESELECT_UNKNOWN = "deselect_unknown";
    public static final String PARAMETER_USE_ABSOLUTE_WEIGHTS = "use_absolute_weights";
    private static final String[] WEIGHT_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less", "top k", "bottom k", "all but top k", "all but bottom k", "top p%", "bottom p%"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private static final int TOPK = 5;
    private static final int BOTTOMK = 6;
    private static final int ALLBUTTOPK = 7;
    private static final int ALLBUTBOTTOMK = 8;
    private static final int TOPPPERCENT = 9;
    private static final int BOTTOMPPERCENT = 10;

    public AttributeWeightSelection(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        AttributeWeights weights = this.getInput(AttributeWeights.class);
        boolean deselectUnknown = this.getParameterAsBoolean(PARAMETER_DESELECT_UNKNOWN);
        double relationWeight = this.getParameterAsDouble(PARAMETER_WEIGHT);
        int relation = this.getParameterAsInt(PARAMETER_WEIGHT_RELATION);
        boolean useAbsoluteWeights = this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS);
        boolean[] weightKnown = new boolean[eSet.getAttributes().size()];
        Vector<Attribute> knownAttributes = new Vector<Attribute>();
        int index = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            double weight = weights.getWeight(attribute.getName());
            if (!Double.isNaN(weight)) {
                knownAttributes.add(attribute);
                weightKnown[index++] = true;
                continue;
            }
            weightKnown[index++] = false;
        }
        int nrAtts = knownAttributes.size();
        int k = this.getParameterAsInt(PARAMETER_K);
        if (relation == 7) {
            relation = 6;
            k = nrAtts - k;
        }
        if (relation == 8) {
            relation = 5;
            k = nrAtts - k;
        }
        if (relation == 9) {
            relation = 5;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (relation == 10) {
            relation = 6;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (k < 1) {
            k = 1;
        }
        if (k > nrAtts) {
            k = nrAtts;
        }
        if (relation == 5 || relation == 6) {
            int direction = 1;
            if (relation == 6) {
                direction = -1;
            }
            int comparatorType = 0;
            if (useAbsoluteWeights) {
                comparatorType = 1;
            }
            String[] attributeNames = new String[knownAttributes.size()];
            index = 0;
            for (Attribute attribute : knownAttributes) {
                attributeNames[index++] = attribute.getName();
            }
            weights.sortByWeight(attributeNames, direction, comparatorType);
            Iterator<Attribute> iterator = eSet.getAttributes().iterator();
            index = 0;
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (!weightKnown[index]) {
                    if (deselectUnknown) {
                        iterator.remove();
                    }
                } else {
                    boolean remove = true;
                    int i = 0;
                    while (i < k) {
                        if (attribute.getName().equals(attributeNames[i])) {
                            remove = false;
                            break;
                        }
                        ++i;
                    }
                    if (remove) {
                        iterator.remove();
                    }
                }
                ++index;
            }
        } else {
            Iterator<Attribute> iterator = eSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                double weight = weights.getWeight(attribute.getName());
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                if (Double.isNaN(weight) && deselectUnknown) {
                    iterator.remove();
                    continue;
                }
                switch (relation) {
                    case 0: {
                        if (!(weight <= relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 1: {
                        if (!(weight < relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 2: {
                        if (weight == relationWeight) break;
                        iterator.remove();
                        break;
                    }
                    case 3: {
                        if (!(weight > relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 4: {
                        if (!(weight >= relationWeight)) break;
                        iterator.remove();
                    }
                }
            }
        }
        return new IOObject[]{eSet};
    }

    public InputDescription getInputDescription(Class cls) {
        if (AttributeWeights.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble(PARAMETER_WEIGHT, "Use this weight for the selection relation.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_WEIGHT_RELATION, "Selects only weights which fulfill this relation.", WEIGHT_RELATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_K, "Number k of attributes to be selected for weight-relations 'top k' or 'bottom k'.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P, "Percentage of attributes to be selected for weight-relations 'top p%' or 'bottom p%'.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_DESELECT_UNKNOWN, "Indicates if attributes which weight is unknown should be deselected.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS, "Indicates if the absolute values of the weights should be used for comparison.", true));
        return types;
    }
}

