/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.KeepBest;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.RedundanceRemoval;
import com.rapidminer.operator.features.selection.BackwardElimination;
import com.rapidminer.operator.features.selection.ForwardSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSelectionOperator
extends FeatureOperator {
    public static final String PARAMETER_SELECTION_DIRECTION = "selection_direction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final int FORWARD_SELECTION = 0;
    public static final int BACKWARD_ELIMINATION = 1;
    private static final String[] DIRECTIONS = new String[]{"forward", "backward"};
    private int generationsWOImp;
    private int maxGenerations;

    public FeatureSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.maxGenerations = this.getParameterAsInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS);
        this.generationsWOImp = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        return super.apply();
    }

    int getDefaultDirection() {
        return 0;
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        int direction = this.getParameterAsInt(PARAMETER_SELECTION_DIRECTION);
        Population initP = new Population();
        if (direction == 0) {
            int a = 0;
            while (a < es.getAttributes().size()) {
                double[] weights = new double[es.getAttributes().size()];
                weights[a] = 1.0;
                initP.add(new Individual(weights));
                ++a;
            }
        } else {
            double[] weights = new double[es.getAttributes().size()];
            int a = 0;
            while (a < es.getAttributes().size()) {
                weights[a] = 1.0;
                ++a;
            }
            initP.add(new Individual(weights));
        }
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        int direction = this.getParameterAsInt(PARAMETER_SELECTION_DIRECTION);
        int keepBest = this.getParameterAsInt(PARAMETER_KEEP_BEST);
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add(new KeepBest(keepBest));
        if (direction == 0) {
            preOp.add(new ForwardSelection());
            this.maxGenerations = this.maxGenerations <= 0 ? input.getAttributes().size() - 1 : --this.maxGenerations;
        } else {
            preOp.add(new BackwardElimination());
            if (this.maxGenerations <= 0) {
                this.maxGenerations = input.getAttributes().size();
            }
        }
        preOp.add(new RedundanceRemoval());
        return preOp;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SELECTION_DIRECTION, "Forward selection or backward elimination.", DIRECTIONS, this.getDefaultDirection());
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_KEEP_BEST, "Keep the best n individuals in each generation.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after n generations without improval of the performance (-1: stops if the maximum_number_of_generations is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Delivers the maximum amount of generations (-1: might use or deselect all features).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

