/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionOperator
extends Operator {
    public static final String PARAMETER_PARTITIONS = "partitions";
    public static final String PARAMETER_RATIO = "ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public PartitionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        List<String[]> ratioList = this.getParameterList(PARAMETER_PARTITIONS);
        double[] ratios = new double[ratioList.size()];
        int i = 0;
        double sum = 0.0;
        for (String[] entry : ratioList) {
            ratios[i] = Double.valueOf(entry[1]);
            sum += ratios[i];
            ++i;
        }
        int j = 0;
        while (j < ratios.length) {
            int n = j++;
            ratios[n] = ratios[n] / sum;
        }
        SplittedExampleSet e = new SplittedExampleSet(this.getInput(ExampleSet.class), ratios, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        LinkedList<SplittedExampleSet> ioo = new LinkedList<SplittedExampleSet>();
        ioo.add(e);
        int j2 = 1;
        while (j2 < ratioList.size()) {
            SplittedExampleSet b = (SplittedExampleSet)e.clone();
            b.selectSingleSubset(j2);
            ioo.add(b);
            ++j2;
        }
        e.selectSingleSubset(0);
        IOObject[] ioos = new IOObject[ioo.size()];
        int j3 = 0;
        while (j3 < ioos.length) {
            ioos[j3] = (IOObject)ioo.get(j3);
            ++j3;
        }
        return ioos;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        int size = 0;
        try {
            size = this.getParameterList(PARAMETER_PARTITIONS).size();
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        Class[] clazz = new Class[size];
        int i = 0;
        while (i < size) {
            clazz[i] = ExampleSet.class;
            ++i;
        }
        return clazz;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_RATIO, "The relative size of this partition.", 0.0, 1.0);
        types.add(new ParameterTypeList(PARAMETER_PARTITIONS, "The partitions that should be created.", type));
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

